; LeTape - 
; by Fbio Belavenuto - Copyright 2004

; Verso 0.1

;Este arquivo  distribuido pela Licena Pblica Geral GNU.
;Veja o arquivo Licenca.txt distribuido com este software.

;ESTE SOFTWARE NO OFERECE NENHUMA GARANTIA

; Esse cdigo fonte deve ser compilado com o Table Assembler

CH	.EQU	$24			; HTAB
CV	.EQU	$25			; VTAB
CS	.EQU	$2E			; Checksum
ENDI	.EQU	$3C
ENDF	.EQU	$3E

TAM	.EQU	$F0
END	.EQU	$F2
SEND	.EQU	$F4
COMP	.EQU	$F6
VERRO	.EQU	$FE
QTDE	.EQU	$B1FF

CHAMAHS	.EQU	$B02C
CHAMAEB	.EQU	$B059
CHAMARB	.EQU	$B083

LEBYTES .EQU	$EE20
RECSIN2	.EQU	$FCFA
RECSIN1	.EQU	$FCFD
LEBYTE	.EQU	$FCEC
COUT	.EQU	$FDED
PRBYTE	.EQU	$FDDA
PRERR	.EQU	$FF2D

	.ORG	$B200

INICIO
	LDA	#$00
	STA	ENDI
	STA	END
	STA	SEND
	LDA	#$40
	STA	ENDI+1
	STA	END+1
	STA	SEND+1
	LDA	#$07
	STA	ENDF
	LDA	#$40
	STA	ENDF+1
INICIO_LG
	DEC	QTDE
	LDA	QTDE
	CMP	#$FF
	BEQ	INICIO_FIM
INICIO_L1
	JSR	LERBLOCO
	JSR	IMPRIME
	LDY	#7
	LDA	(SEND),Y
	BNE	INICIO_BN0

	LDY	#$A
	LDA	(SEND),Y
	SEC
	LDY	#8
	SBC	(SEND),Y
	STA	COMP
	LDY	#$B
	LDA	(SEND),Y
	LDY	#9
	SBC	(SEND),Y
	STA	COMP+1
	LDA	COMP
	CLC
	ADC	#1
	STA	COMP
	LDA	COMP+1
	ADC	#0
	STA	COMP+1
INICIO_BN0
	LDA	ENDF
	CLC
	ADC	#1
	STA	ENDI
	STA	SEND
	CLC
	ADC	#7
	STA	ENDF
	LDA	ENDF+1
	STA	ENDI+1
	STA	SEND+1
	ADC	#0
	STA	ENDF+1

	LDA	COMP+1
	BNE	INICIO_L1
	LDA	COMP
	BNE	INICIO_L1
	JMP	INICIO_LG

INICIO_FIM	
	LDA	ENDI
	STA	TAM
	LDA	ENDI+1
	SEC
	SBC	#$40
	STA	TAM+1
	LDA	#' ' | $80
	JSR	COUT
	LDA	#'E' | $80
	JSR	COUT
	LDA	#'N' | $80
	JSR	COUT
	LDA	#'V' | $80
	JSR	COUT
	JMP	ENVMEM

LERBLOCO
	LDA	#$FF
	STA	CS
LERBLOCO_L1
	LDX	#$10
LERBLOCO_L2
	LDY	#$25			; Espera 16 vezes o cabecalho B
	JSR	RECSIN1
	BCC	LERBLOCO_L1
	DEX
	BNE	LERBLOCO_L2
	;LDY	#$FF
	;JSR	RECSIN1
LERBLOCO_L3
	LDY	#$24			; Pula restante do cabecalho B
	JSR	RECSIN1
	BCS	LERBLOCO_L3
	JSR	RECSIN1			; Pula bit stop 0
	LDY	#$3A
	JSR	LEBYTES			; Ler bytes de ($3C) at ($3E)
	JSR	VERBLOCO
	JSR	LEBYTES			; Ler bytes de ($3C) at ($3E)
;	LDY	#$34
;	JSR	LEBYTE			; Ler Checksum
;	CMP	CS
;	BNE	ERRO
	RTS				; Retorna
DBG
	LDA	$3C
	STA	$6200
	LDA	$3D
	STA	$6201
	LDA	$3E
	STA	$6202
	LDA	$3F
	STA	$6203
	JMP	$FF61
ERRO
	PLA
	PLA
	JMP	PRERR

VERBLOCO
	LDA	(ENDF,X)
	BEQ	VERBLOCO_E0		; Se for o bloco 0, pula
	LDA	COMP+1			; Bloco > 0, ler mais bytes
	BNE	VERBLOCO_P1
	LDA	ENDF			; bloco < 256
	SEC				; Somar 1 por causa do Checksum
	ADC	COMP
	STA	ENDF
	LDA	ENDF+1
	ADC	#$00
	STA	ENDF+1
	LDA	#$00
	STA	COMP
	LDY	#$32
	RTS

VERBLOCO_P1
	LDA	ENDF			; bloco >= 256
	CLC
	ADC	#1			; Somar 1 por causa do Checksum
	STA	ENDF
	LDA	ENDF+1
	ADC	#1
	STA	ENDF+1
	DEC	COMP+1
	LDY	#$32
	RTS
	
	
VERBLOCO_E0
	LDA	ENDF
	CLC
	ADC	#$05			; 4 + 1 do Checksum
	STA	ENDF
	LDY	#$34
	RTS

IMPRIME
	LDA	#23
	STA	CV
	LDY	#0
	STY	CH
IMPRIME_L1
	LDA	(SEND),Y
	JSR	COUT
	INY
	CPY	#6
	BNE	IMPRIME_L1
IMPRIME_L2
	LDA	#' ' | $80
	JSR	COUT
	LDA	(SEND),Y
	JSR	PRBYTE
	INY
	CPY	#8
	BNE	IMPRIME_L2
	RTS

ENVMEM
	JSR	CHAMAHS
	LDA	VERRO
	BNE	ENVMEM_ERRO
	LDA	TAM
	JSR	CHAMAEB
	LDA	TAM+1
	JSR	CHAMAEB

	LDY	#0
ENVMEM_LOOP
	DEC	TAM
	LDA	TAM
	CMP	#$FF
	BNE	ENVMEM_PULA1
	DEC	TAM+1
	LDA	TAM+1
	CMP	#$FF
	BEQ	ENVMEM_FIM
ENVMEM_PULA1
	LDA	(END),Y
	JSR	CHAMAEB
	INC	END
	LDA	END
	BNE	ENVMEM_LOOP
	INC	END+1
	JMP	ENVMEM_LOOP
ENVMEM_FIM
	RTS

ENVMEM_ERRO
	JMP	PRERR

	.END
