
VSTART	equ	$0e00			;1536	; inicio da memoria de video
VOFFSET	equ	$0800				; offset para o endereco de video original

	org	$2a00


	;org	19426		; ed 49
GBIN	jsr	START
	lda	#5
	sta	LIVES
	clr	LEVEL
	ldx	#SCORE
	ldb	#6
GBINI	clr	,x+
	decb
	bne	GBINI
	lbra	NLV
	rts

	;org	19000	; ed 38
START	jsr	CLS

	ldx	#TITPOS
	ldy	#TITLE
	ldb	#TITLEN
	jsr	IPRINT
	ldx	#CREPOS-224
	ldb	#CRELEN
	jsr	IPRINT
	ldx	#WRI1POS-224
	ldb	#WRI1LEN
	jsr	IPRINT
	ldx	#WRI2POS-224
	ldb	#WRI2LEN
	jsr	IPRINT

	; creditos da digitação e correções

	ldx	#1024+10*32+TYPPOS		; linha 10 coluna 6
	ldb	#TYPLEN
	ldy	#TYPTIT
	jsr	IPRINT
	ldx	#1024+12*32+7		; linha 12 coluna 7
	ldb	#18
	ldy	#TYPNAM
	jsr	IPRINT
	ldx	#1024+13*32+7		; linha 13 coluna 7
	ldb	#18
	ldy	#TYPURL
	jsr	IPRINT
	ldx	#1024+14*32+14		; linha 14 coluna 14
	ldb	#4
	ldy	#TYPYEAR
	jsr	IPRINT



	lda	#5
PAUSE	ldx	#65535
PAUSEI	leax	-1,x
	bne	PAUSEI
	deca
	bne	PAUSE
	jsr	CLS
	; rts


	; org 19054 ; ed 39
	ldx	#1024
	ldy	#DESCR
	clrb
	jsr	IPRINT
	ldb	#DESCRL
	jsr	IPRINT
	leax	MOFSET,x
	ldb	#MLEN
	jsr	IPRINT
	leax	NOFSET,x
	ldb	#NLEN
	jsr	IPRINT
	leax	MNOFSET,x
	ldb	#MNLEN
	jsr	IPRINT
KEY	jsr	41409
	cmpa	#83
	bne	KEY
	rts


	; org	19109 /// ed 42
SCENE	jsr	MODE
	jsr	GCLS
	ldx	#VSTART+4095
	ldy	#SHAPE
	ldb	#32
LOOP	pshs	b
	jsr	SCROLL
	jsr	PRINT
	puls	b
	decb
	bne	LOOP
	ldy	#IMSUN
	ldx	#VSTART+33
	jsr	PRSUN
	rts




	; org	19148  /// ed 38
CLS	ldx	#1024
	lda	#32
CLSI	sta	,x+
	cmpx	#VSTART
	blo	CLSI
	rts

	; org 19161   /// ed 42
GCLS	ldx	#VSTART
	lda	#85
GCLSI	sta	,x+
	cmpx	#VSTART+6144
	blo	GCLSI
	rts

	;org	19174 /// ed 38
LPRINT	lda	,y+
	sta	,x+
	decb
	bne	LPRINT
	rts


	;org	19182 /// ed 42
MODE	lda	#229
	sta	65475		; VDG V1
	sta	65477		; VDG v2
	sta	65479		; VDG F0 ; memory $0600
	sta	65483		; VDG F1 ; memory $0e00
	sta	65314		; mode
 	rts

SCROLL	pshs	x,y
	ldx	#VSTART
	ldy	#VSTART+1
SCRO	lda	,y+
	sta	,x+
	cmpx	#VSTART+6143
	blo	SCRO
	puls	y,x
	rts

PRINT	pshs	x
	lda	,y+
	suba	#33
	bne	PRZ
	puls	x
	leax	-256,x
	pshs	x
	pshs	y
	ldy	#IMCLIFF		;17536
	ldb	#8
PRI	lda	,y+
	sta	,x
	leax	32,x
	decb
	bne	PRI
	puls	y	
PRZ	clr	,x
	leax	32,x
	cmpx	#VSTART+6144
	blo	PRZ
	puls	x
	rts

PRSUN	ldb	#30
PRSUNI	pshs	b
	ldb	#4
PRSUNZ	lda	,y+
	sta	,x+
	decb
	bne	PRSUNZ
	leax	28,x
	puls	b
	decb
	bne	PRSUNI
	rts


	; org 19289 - ed 48
ELB	lda	LEVEL
	ldb	#16
	mul
	addd	#IMPRIZE	; 18142
	tfr	d,u
	ldx	#2782+VOFFSET
	jsr	CHARPR
	lda	LEVEL
	beq	ED
	pshs	a
	jsr	HOLES
	puls	a
	cmpa	#1
	beq	ED
	jsr	SNAKE
ED	rts

HOLES	ldx	#5095+VOFFSET
	ldu	#3071+VOFFSET
	jsr	HOLPR
	ldx	#4591+VOFFSET
	ldu	#3071+VOFFSET
	jsr	HOLPR
	ldx	#3833+VOFFSET
	ldu	#3071+VOFFSET
	jsr	HOLPR
	rts

SNAKE	ldx	#5095+VOFFSET
	ldu	#IMSNAKE
	jsr	HOLPR
	ldx	#4591+VOFFSET
	ldu	#IMSNAKE
	jsr	HOLPR
	ldx	#3833+VOFFSET
	ldu	#IMSNAKE
	jsr	HOLPR
	rts

HOLPR	ldb	#4
HOLPRI	pshs	u,x,b
	jsr	CHARPR
	puls	b,x,u
	leax	256,x
	leau	16,u
	decb
	bne	HOLPRI
	rts

CHARPR	ldb	#2
CHARI	pshs	b,x
	ldb	#8
CHARZ	pulu	a
	sta	,x
	leax	32,x
	decb
	bne	CHARZ
	puls	x,b
	leax	1,x
	decb
	bne	CHARI
	rts


	;org	19447		; ed 50
NLV	lda	#6
	sta	TIDELAY
	ldx	#7424+VOFFSET
	stx	TIDEPOS
	ldx	#5088+VOFFSET
	stx	WILPOS
	clr	WILSTAT
	clr	GAMSTAT
	ldx	#3070+VOFFSET
	stx	STONPOS
	clr	SNKTONG
	lda	#5
	sta	SNKTONG+1
	lda	#10
	sta	SNKTONG+2
	; rts


	;org	19489		; ed 51
	jsr	SCENE
	ldx	#1807+VOFFSET
	ldu	#IMSCORE	; 17544
	ldb	#5
SCPR	lda	#3
SCPRI	pulu	y
	sty	,x++
	deca
	bne	SCPRI
	leax	26,x
	decb
	bne	SCPR
	jsr	PRSC
	ldx	#2063+VOFFSET
	ldu	#IMLIVES	; 17574
	ldb	#5
SCPRZ	lda	#3
SCPRC	pulu	y
	sty	,x++
	deca
	bne	SCPRC
	leax	26,x
	decb
	bne	SCPRZ
	lda	LIVES
	ldb	#5
	mul
	addd	#IMNUMS
	tfr	d,u
	ldx	#2070+VOFFSET
	ldb	#5
SCPRD	pulu	a
	sta	,x
	leax	32,x
	decb
	bne	SCPRD
	jsr	ED40	; musica

	; org	19572	; ed 64
	jmp	ALP


PRSC	pshs	d,x,y
	ldx	#SCORE
	ldb	#6
	ldy	#1814+VOFFSET
PRSCB	lda	,x
	pshs	x,b
	bitb	#1
	bne	ROLL
	ldb	#5
	mul
	addd	#IMNUMS
	tfr	d,x
	pshs	y
	ldb	#5
PRSCA	lda	,x+
	sta	,y
	leay	32,y
	decb
	bne	PRSCA
	puls	y
	leay	1,y
ROLRET	puls	b,x
	leax	1,x
	decb
	bne	PRSCB
	puls	y,x,d
	rts
ROLL	ldb	#5
	mul
	addd	#IMNUMS
	tfr	d,x
	pshs	y
	ldb	#5
RLLA	lda	,x+
	pshs	a
	anda	#15
	lsla
	lsla
	lsla
	lsla
	ora	#5
	sta	1,y
	puls	a
	lsra
	lsra
	lsra
	lsra
	ora	#$50
	sta	,y
	leay	32,y
	decb
	bne	RLLA
	puls	y
	leay	2,y
	bra	ROLRET
	

	;org	19678		; ED 53
SEA	ldu	#IMSEA1
	lda	TIDELAY		; 18246
	bita	#2
	beq	SPT
	ldu	#IMSEA2
SPT	ldx	TIDEPOS		; 18247
	lda	#16
SPTI	pshs	a,u
	jsr	CHARPR
	puls	u,a
	deca
	bne	SPTI
	dec	TIDELAY		; 18246
	bne	SRT
	lda	#10
	sta	TIDELAY		; 18246
	ldx	TIDEPOS		; 18247
	leax	-256,x
	stx	TIDEPOS		; 18247
SRT	rts


	;org	19727	; ed 54
MOVSUN	dec	SUNDLAY
	bne	SUNRET
	lda	#5
	sta	SUNDLAY
	sync
	ldx	#1569+VOFFSET
	lda	#30
MOVA	pshs	a
	lda	#2
MOVB	andcc	#$fe
	pshs	CC
	CLRB
MOVC	puls	CC
	ror	b,x
	pshs	CC
	incb
	cmpb	#14
	bne	MOVC
	lsl	,x
	puls	CC
	ror	,x
	deca
	bne	MOVB
	leax	32,x
	puls	a
	deca
	bne	MOVA
SUNRET	rts



	;org	19789	; ed 56
BAR	lda	LEVEL
	beq	BLM
	cmpa	#3
	beq	BLM
	rts

BLM	ldx	STONPOS
	ldu	#1536+VOFFSET
	pshs	x
	jsr	CHARPR
	puls	x
	leax	-1,x
	cmpx	#5344+VOFFSET
	beq	BRI
	stx	STONPOS
	lda	,x
	cmpa	#$AA
	beq	BRI
	cmpa	#$55
	beq	BNH
	cmpa	#$5D		; bug sem errata (era #$50)
	beq	BNH
	lda	#2
	sta	GAMSTAT
BNH	leax	289,x
	lda	,x
	cmpa	#$AA
	beq	BRI
	cmpa	#$55
	bne	BOK
	leax	-33,x
	stx	STONPOS

	;org	19853	; ed 57    ; (bug - seria 19861)
BOK	lda	STSTATE
	beq	BMN
	ldx	STONPOS
	ldu	#IMSTON2
	jsr	CHARPR
	clr	STSTATE
	rts

BMN	ldx	STONPOS
	ldu	#IMSTON1
	jsr	CHARPR
	lda	#1
	sta	STSTATE
	rts
BRI	ldx	STONPOS
	ldu	#1536+VOFFSET
	jsr	CHARPR
	ldx	#3070+VOFFSET
	stx	STONPOS
	rts
	

	;org	19902	; ed 58
MAN	ldd	WILPOS	; 18249
	andb	#31
	cmpb	#30
	bne	MANI
	lda	#1
	sta	GAMSTAT	; 18252
MANI	lda	JUMPING	; 18261
	lbne	JUM
	ldx	WILPOS	; 18249
	leax	544,x
	ldx	,x
	cmpx	#$5555
	lbeq	MDY
	cmpx	#$AAAA
	lbeq	MDY
	cmpx	#$5ff5
	lbeq	MDY
	clrb
	clr	WALKING	; 18264
	lda	#$df
	sta	$ff02
	lda	$ff00
	sta	KNSTATE	; 18262
	lda	#$bf
	sta	$ff02
	lda	$ff00
	sta	KMSTATE	; 18263
	cmpa	#$fd
	bne	MANA	; bug bnee?
	ldb	#1
	lda	KNSTATE	; 18262
	cmpa	#$fd
	bne	MAND
	ldb	#129
MAND	stb	JUMPING	; 18261
	lda	WALKING	; 18264
	bne	MANC
	ldx	WILPOS	; 18249
	pshs	x
	bra	MMI
MANA	lda	KNSTATE	; 18262
	cmpa	#$fd
	bne	MAND
	lda	#1
	sta	WALKING	; 18264
	bra	MAND
MANC	ldx	WILPOS	; 18249
	ldu	#1536+VOFFSET
	jsr	CHARPR
	leax	254,x
	jsr	CHARPR
	ldx	WILPOS	; 18249
	leax	1,x
	pshs	x
	leax	353,x
	lda	,x
	cmpa	#$d5
	beq	MDYA
	cmpa	#$ff
	beq	MDYA
	cmpa	#$50
	beq	MTS
	lda	WILSTAT	; 18251
	beq	MMO
MMI	ldx	,s
	ldu	#IMWIL1
	jsr	CHARPR
	ldx	,s
	leax	256,x
	jsr	CHARPR
	clr	WILSTAT	; 18251
	bra	MANE
MMO	ldx	,s
	ldu	#IMWIL2
	jsr	CHARPR
	ldx	,s
	leax	256,x
	ldu	#IMWIL3
	jsr	CHARPR
	lda	#1
	sta	WILSTAT	; 18251
MANE	ldx	,s
	stx	WILPOS	; 18249
	puls	x
	rts
MDYA	puls	x
MDY	lda	#2
	sta	GAMSTAT	; 18252
	rts
MTS	puls	x
	leax	-1,x
	pshs	x
	bra	MMI

	; org	20140	; ed 59
JUM	jsr	CLICK
	lda	JUMPING	; 18261
	cmpa	#1
	bne	MJA
	inc	JUMPING	; 18261
	ldx	WILPOS	; 18249
	pshs	x
	leax	256,x
	ldu	#1536+VOFFSET
	jsr	CHARPR
	puls	x
	leax	-256,x
	stx	WILPOS	; 18249
	ldu	#IMWIL2
	jsr	CHARPR
	leax	254,x
	ldu	#IMWIL3
	jsr	CHARPR
	rts
MJA	cmpa	#2
	bne	MJB
	inc	JUMPING	; 18261
	ldx	WILPOS	; 18249
	leax	-256,x
	ldu	#IMWIL4
	jsr	CHARPR
	leax	254,x
	jsr	CHARPR
	leax	254,x
	jsr	CHARPR
	rts
MJB	cmpa	#3
	bne	MJC
	inc	JUMPING	; 18261
	ldx	WILPOS	; 18249
	leax	-256,x
	ldu	#1536+VOFFSET
	jsr	CHARPR
	leax	254,x
	ldu	#IMWIL5
	jsr	CHARPR
	leax	254,x
	ldu	#IMWIL6
	jsr	CHARPR
	leax	254,x
	ldu	#IMWIL7
	rts
MJC	cmpa	#4
	bne	MFJ
	clr	JUMPING	; 18261
	ldx	WILPOS	; 18249
	pshs	x
	ldu	#1536+VOFFSET
	jsr	CHARPR
	puls	x
	leax	256,x
	stx	WILPOS	; 18249
	ldu	#IMWIL1
	jsr	CHARPR
	leax	254,x
	jsr	CHARPR
	rts

	;org	20321	; ed 60
MFJ	cmpa	#129
	bne	MFB
	inc	JUMPING	; 18261
	ldx	WILPOS	; 18249
	leax	290,x
	lda	,x
	cmpa	#$57
	lbeq	MDY
	jsr	MFZ
	ldx	WILPOS	; 18249
	leax	-255,x
	stx	WILPOS	; 18249
	ldu	#IMWIL2
	jsr	CHARPR
	leax	254,x
	ldu	#IMWIL3
	jsr	CHARPR
	rts
MFB	cmpa	#130
	bne	MFC
	inc	JUMPING	; 18261
	jsr	MFZ
	ldx	WILPOS	; 18249
	leax	-255,x
	stx	WILPOS	; 18249
	ldu	#IMWIL4
	jsr	CHARPR
	leax	254,x
	jsr	CHARPR
	leax	254,x
	jsr	CHARPR
	ldx	WILPOS	; 18249
	leax	864,x
	lda	,x+
	cmpa	#$ff
	beq	MFF
	lda	,x
	cmpa	#$ff
	beq	MFF
	rts
MFF	lda	#4
	ldb	#5
	jsr	SCI
	rts
MFC	cmpa	#131
	bne	MFD
	inc	JUMPING	; 18261
	jsr	MFZ
	leax	254,x
	ldu	#1536+VOFFSET
	jsr	CHARPR
	ldx	WILPOS	; 18249
	leax	257,x
	stx	WILPOS	; 18249
	ldu	#IMWIL2
	jsr	CHARPR
	leax	254,x
	ldu	#IMWIL3
	jsr	CHARPR
	rts
MFD	cmpa	#132
	bne	MFE
	jsr	MFZ
	ldx	WILPOS	; 18249
	pshs	x
	leax	512,x
	ldy	,x
	puls	x
	cmpy	#$5555
	bne	MFE
	leax	1,x
	stx	WILPOS	; 18249
MFE	clr	JUMPING	; 18261
	clr	WILSTAT	; 18251
	ldx	WILPOS	; 18249
	ldu	#IMWIL1
	jsr	CHARPR
	rts
MFZ	ldx	WILPOS	; 18249
	ldu	#1536+VOFFSET
	jsr	CHARPR
	leax	254,x
	jsr	CHARPR
	rts


	;org	20560	// ed 61
DIE	lda	#136
	ldx	#140
	jsr	SOUND
	lda	#131
	ldx	#213
	jsr	SOUND
DI	ldx	WILPOS
	ldu	#1536+VOFFSET
	jsr	CHARPR
	leax	254,x
	stx	WILPOS
	ldu	#IMWIL1
	jsr	CHARPR
	leax	254,x
	jsr	CHARPR
	lda	#30
	ldx	#113
	jsr	SOUND
	ldx	WILPOS
	cmpx	#6912+VOFFSET
	blo	DI
	dec	LIVES
	lbne	NLV

	; bug sem errata nas linhas a seguir... corrigido
	lda	#5
PB	ldx	#32767
PAA	leax	-1,x
	bne	PAA
	deca
	bne	PB

	jsr	CLS
	lda	$ff22
	anda	#15
	sta	$ff22
	sta	$ffc2
	sta	$ffc4
	sta	$ffc6
	sta	$ffca	; desativa end video $0e00
	ldy	#$50b
	ldx	#$701
	stx	,y++
	ldx	#$d05
	stx	,y++
	ldx	#$200f
	stx	,y++
	ldx	#$1605
	stx	,y++
	ldx	#$1221
	stx	,y++
	lda	#200
	ldx	#255
	jsr	SOUND
	lda	#200
	ldx	#200
	jsr	SOUND
	lda	#255
	ldx	#255
	jsr	SOUND
	lda	#100
	sta	DLL+1
	lbra	GBIN


	; org	20721 	; ed 62
RWD	lda	#255
	ldx	#150
	jsr	SOUND
	lda	LEVEL
	inca
	anda	#3
	sta	LEVEL
	dec	DLL+1
	ldb	#5
	lda	#3
	jsr	SCI
	lbra	NLV
SCI	exg	a,b
SCT	ldx	#SCORE
	abx
	pshs	a,x
	jsr	SDI
	puls	a,x
	deca
	bne	SCT
	jsr	PRSC
	rts
SDI	lda	,x
	inca
	cmpa	#10
	bne	SNO
	clr	,x
	leax	-1,x
	bra	SDI
SNO	sta	,x
	rts
SOUND	pshs	a
	lda	$ff01
	anda	#247
	sta	$ff01
	lda	$ff03
	anda	#247
	sta	$ff03
	lda	$ff23
	ora	#8
	sta	$ff23
	orcc	#$50
	puls	a
	pshs	x
	ldb	#252
SBN	stb	$ff20
SC	leax	-1,x
	bne	SC
	ldx	,s
	clr	$ff20
SD	leax	-1,x
	bne	SD
	ldx	,s
	deca
	bne	SBN
	andcc	#$af
	puls	x
	rts
CLICK	ldx	#98
	lda	#4
	jsr	SOUND
	rts

	; org	20856	; ed 63
SNK	lda	LEVEL
	cmpa	#2
	bhs	SKO
	rts
SKO	ldy	#SNKTONG
	ldx	#5095+VOFFSET
	jsr	SKM
	ldx	#4591+VOFFSET
	jsr	SKM
	ldx	#3833+VOFFSET
	jsr	SKM
	rts
SKM	pshs	x
	ldx	TIDEPOS
	leax	31,x
	cmpx	,s
	puls	x
	bhi	SNS
	rts
SNS	lda	,y
	inca
	anda	#$f
	sta	,y+
	cmpa	#7
	bhs	SCO
	rts
SCO	ldu	#IMSNKTG
	cmpa	#15
	bne	STE
	ldu	#1536+VOFFSET
STE	leax	-256,x
	jsr	CHARPR
	rts


	; org	20932	; ed 64
ALP	lda	#5
	sta	SUNDLAY
	clr	JUMPING
	jsr	ELB
BLP	jsr	MAN
	jsr	BAR
	jsr	SNK
	jsr	SEA
	jsr	MOVSUN
	lda	GAMSTAT
	cmpa	#1
	lbeq	RWD
	cmpa	#2
	lbeq	DIE
DLL	ldb	#100
DEL	clra
DELA	deca
	bne	DELA
	decb
	bne	DEL
	jsr	41409
	cmpa	#3
	bne	BLP
	rts


;/// by claudemir
IPRINT	lda	,y+
	cmpa	#97
	blo	ZPRINT
	sta	,x
	lda	#159
	anda	,x
ZPRINT	sta	,x+
	decb
	bne	IPRINT
	rts


	;org 30000
ED40	ldx	#MUSIC
	stx	MUPOINT
	lda	#19
ONENOTE	pshs	a
	lda	$FF01
	anda	#247
	sta	$FF01
	lda	$FF03
	anda	#247
	sta	$FF03
	lda	$FF23
	ora	#8
	sta	$FF23
MAIN	ldu	MUPOINT
	orcc	#$50
	pulu	a,x
	cmpu	#MUSIC+57
	blo	MONE
	ldu	#MUSIC
MONE	stu	MUPOINT
	pshs	x
	ldb	#252
MTWO	stb	$ff20
MTHR	leax	-1,x
	bne	MTHR
	ldx	,s
	clr	$FF20
MFOU	leax	-1,x
	bne	MFOU
	ldx	,s
	deca
	bne	MTWO
	leas	2,s
	dec	,s
	bne	MAIN
	andcc	#$AF
	puls	a,pc
MUPOINT	fdb	$758A
MUSIC	fcb	98,0,189,233
	fcb	0,158,131,0
	fcb	141,220,0,125
	fcb	78,0,118,147
	fcb	0,125,255,0
	fcb	141,110,0,168
	fcb	131,0,212,49
	fcb	0,189,110,0
	fcb	168,233,0,158
	fcb	98,0,189,147
	fcb	0,189,44,0
	fcb	212,98,0,189
	fcb	220,0,168,92
	fcb	0,200,220,0,252


	IFDEF	PTBR
TITLE	fcc	"avalanchecriacao: a.doe programa: s. kellaway e g. hedley"

TITPOS	equ	1066
TITLEN	equ	9

CREPOS	equ	1384
CRELEN	equ	15

WRI1POS	equ	1445
WRI1LEN	equ	21

WRI2POS	equ	1481
WRI2LEN	equ	12


DESCR	fcc	" depois de um pequeno passeio   "
	fcc     " willie descobre que cabritos   "
	fcc     " monteses espalharam todo seu   "
	fcc	" lanche pela encosta.           "
	fcc	" agora ele tem de subir ao topo "
	fcc	" da montanha pegar suas coisas. "
	fcc	" no caminho ele sera ameacado   "
	fcc	" por pedras, cobras e buracos.  "
	fcc	" para piorar a situacao, a mare "
	fcc	" esta subindo, podendo afoga-lo."
	fcc	" para ajudar willie leia as     "
	fcc	" instrucoes e aperte 's' para   "
	fcc	" jogar.  "
DESCRL	equ	137
CKEYS	fcc	"m - corrern - saltarmn - ambos"
MLEN	equ	10
NLEN	equ	10
MNLEN	equ	10
MOFSET	equ	24
NOFSET	equ	22
MNOFSET	equ	22
	ELSE
TITLE	fcc	"cliffhangercreated by a.doewritten by s.kellawayand g.hedley"
TITPOS	equ	1066
TITLEN	equ	11

CREPOS	equ	1384
CRELEN	equ	16

WRI1POS	equ	1445
WRI1LEN	equ	21

WRI2POS	equ	1481
WRI2LEN	equ	12


DESCR	fcc	" after a short walk willie      "
	fcc     " returns to find the goats have "
	fcc     " spread his picnic goodies all  "
	fcc	" over a rocky embankment.       "
	fcc	" willie sets off to reclaim his "
	fcc	" lost possessions, but is       "
	fcc	" hampered by falling boulders,  "
	fcc	" pot holes, and vicious snakes. "
	fcc	" to make matters worse the tide "
	fcc	" is rising and he is in danger  "
	fcc	" of being cutoff. to help willie"
	fcc	" in his quest read the following"
	fcc	" and press 's' to start"
CKEYS	fcc	"m    - runn    - jumpboth - diagnonal jump"
DESCRL	equ	151
MLEN	equ	10
NLEN	equ	11
MNLEN	equ	21
MOFSET	equ	10
NOFSET	equ	22
MNOFSET	equ	21
	ENDC



	; ed 41
	;org	17503
SHAPE	fcc	"###!##!###!##!####!##!##!###!##!!"

;linha 210
IMCLIFF	fcb     $55,$54,$50,$50,$40,$40,$00,$00

IMSCORE	fcb	$7F,$5F,$57
	fcb	$D7,$F5,$FF,$D5,$75,$DD,$77,$5D,$D5,$7D,$75
	fcb	$5D,$77,$F5,$FD,$57,$75,$DD,$77,$5D,$D5,$FD,$5F
	fcb	$57,$D7,$5D,$FF

IMLIVES	fcb	$D5,$7F,$75,$77,$FD,$F7,$D5
	fcb	$5D,$75,$77,$55,$D5,$D5,$5D,$5D,$D7,$F5,$7D,$D5
	fcb	$5D,$5D,$D7,$55,$57,$FF,$7F,$57,$57,$FD,$FD

;linha 230 sol
IMSUN	fcb	$55,$75,$D5,$55,$55,$75,$D5,$55,$75,$75,$D5,$D5
	fcb	$5D,$5D,$D5,$D5,$5D,$5D,$D7,$55,$57,$5D,$D7,$5D
	fcb	$D5,$D5,$5D,$5D,$75,$D7,$DD,$75,$7D,$5D
	fcb	$75,$D5,$5D,$75,$5D,$D7,$57,$75,$5D,$5D,$F5
	fcb	$D5,$57,$75,$5D,$D5,$57,$75,$57,$55,$55,$D7,$F7
	fcb	$55,$55,$DD

;linha 240
	fcb	$57,$55,$55,$D5,$77,$55,$55,$DF,$D5,$D5,$57
	fcb	$55,$5D,$D5,$57,$7F,$F5,$75,$5D,$55,$57,$75
	fcb	$5D,$F5,$57,$5D,$75,$5F,$5D,$57,$D7,$55,$75
	fcb	$75,$57,$55,$55,$77,$75,$D5,$55,$D7,$75,$D5
	fcb	$55,$D7,$75,$75,$57,$57,$5D,$75,$57,$57,$5D
	fcb	$55,$55,$57,$5D,$55


;numeros
;linha 260
IMNUMS	fcb	$7D,$D7,$D7,$D7,$7D
	fcb	$5D,$7D,$5D,$5D,$FF
	fcb	$7D,$D7,$5D,$75,$FF
	fcb	$FD,$57,$FD,$57,$FD
	fcb	$5D,$7D,$DD,$FF,$5D
	fcb	$FF,$D5,$7D,$57,$FD
	fcb	$7F,$D5,$FD,$D7,$7D
	fcb	$FF,$57,$5D,$75,$75
	fcb	$7D,$D7,$7D,$D7,$7D
	fcb	$7F,$D7,$7F,$57,$57

;graficos
;linha 280


IMWIL1	fcb	$57,$5F,$5F,$57,$5F,$5F,$5F,$5F
	fcb	$D5,$F5,$F5,$D5,$F5,$F5,$F5,$F5
	fcb	$5F,$5F,$57,$57,$57,$57,$57,$57
	fcb	$F5,$F5,$D5,$D5,$D5,$D5,$D5,$FD
	fcb	$55,$55,$55,$55,$55,$55,$55,$55

IMWIL2	fcb	$57,$5F,$5F,$57,$55,$57,$57,$57
	fcb	$D5,$F5,$F5,$D5,$55,$55,$55,$FD
	fcb	$55,$55,$55,$55,$55,$55,$55,$55
	fcb	$55,$55,$55,$55,$55,$55,$55,$55

IMWIL3	fcb	$FD,$55,$57,$5D,$75,$D5,$75,$55

;linha 290
	fcb	$55,$55,$D5,$75,$5D,$5D,$5F,$55
	fcb	$55,$55,$55,$55,$55,$55,$55,$55

IMWIL4	fcb	$55,$55,$55,$55,$57,$5F,$5F,$57
	fcb	$55,$55,$55,$55,$D5,$F5,$F5,$D5
	fcb	$55,$57,$57,$57,$FD,$55,$57,$5D

	fcb	$55,$55,$55,$FD,$55,$55,$D5,$75
	fcb	$75,$d5,$75,$55,$55,$55,$55,$55
	fcb	$5d,$5d,$5f,$55,$55,$55,$55,$55
	fcb	$55,$55,$55,$55,$55,$55,$55,$55

IMWIL5	fcb	$55,$55,$55,$55,$57,$5f,$5f,$57


;linha 300
	fcb	$55,$55,$55,$55,$D5,$F5,$F5,$D5
	fcb	$55,$55,$55,$55,$55,$55,$55,$55
	fcb	$55,$55,$55,$55,$55,$55,$55,$55

IMWIL6	fcb	$55,$57,$57,$57,$FD,$55,$57,$5D
	fcb	$55,$55,$55,$FD,$55,$55,$D5,$75
	fcb	$55,$55,$55,$55,$55,$55,$55,$55
	fcb	$55,$55,$55,$55,$55,$55,$55,$55

IMWIL7	fcb	$75,$D5,$75,$55,$55,$55,$55,$55
	fcb	$5D,$5D,$5F,$55,$55,$55,$55,$55
	fcb	$55,$55


;linha 310                                      =
	fcb	        $55,$55,$55,$55,$55,$55


IMSTON1	fcb	$57,$5F,$7F,$FF,$FF,$FF,$7F,$5F
	fcb	$F5,$FD,$FF,$FF,$FF,$FD,$F5,$D5
	fcb	$55,$55,$55,$55,$55,$55,$55,$55


IMSTON2	fcb	$5F,$7F,$FF,$FF,$FF,$7F,$5F,$57
	fcb	$D5,$F5,$FD,$FF,$FF,$FF,$FD,$F5
	fcb	$55,$55,$55,$55,$55,$55,$55,$55

IMSNKTG	fcb	$5D,$57,$55,$55,$55,$55,$55,$55
	fcb	$5D,$75,$D5,$D5,$D5,$D5,$D5,$D5

IMSNAKE	fcb	$57,$5F,$7D,$7F,$7F,$5F,$57
	fcb	$57,$D5,$F5


;linha 320
	fcb	$FD,$FD,$FD,$F5,$D5,$D5,$57,$57,$55,$55,$55
	fcb	$55,$55,$55,$D5,$D5,$F5,$F5,$7D,$7D,$5F,$5F
	fcb	$55,$55,$55,$55,$57,$57,$5F,$5F,$7D,$7D,$F5
	fcb	$F5,$D5,$D5,$55,$55,$7D,$7D,$F5,$F5,$7D,$7D
	fcb	$5F,$5F,$55,$55,$7D,$5F,$7D,$F5,$D5,$D5

IMPRIZE	fcb	$55
	fcb	$55,$AA,$AA,$53,$56,$AA,$AA,$55,$55,$AA,$AA
	fcb	$95,$95,$AA,$AA,$55,$55,$7F,$FF,$FF,$FF,$7F
	fcb	$5F,$81

;linha 330
	fcb	$15,$7D,$FF,$FF,$FF,$FD,$F5,$57,$57,$57,$F5
	fcb	$F5,$F5,$F5,$F5,$55,$55,$55,$D5,$D5,$D5,$D5
	fcb	$57,$5F,$7F,$5F,$5F,$5F,$57,$57,$55,$D5,$F5
	fcb	$D5,$D5,$D5,$55,$55


IMSEA1	fcb	$AA,$AA,$AA,$A6,$99,$6A,$AA,$AA
	fcb	$AA,$AA,$AA,$AA,$A9,$66,$9A,$AA

IMSEA2	fcb	$AA,$AA,$AA,$6A,$9A,$A6,$A9,$AA
	fcb	$AA,$AA,$AA,$A6,$99,$6A,$AA,$AA


	IFDEF	PTBR
TYPTIT	fcc	"digitacao e ajustes:"
TYPLEN	equ	20
TYPPOS	equ	6
	ELSE
TYPTIT	fcc	"typing and corrections:"
TYPLEN	equ	23
TYPPOS	equ	4
	ENDC

TYPNAM	fcc	"claudemir todo bom"
TYPURL	fcc	"http://todobom.com"
TYPYEAR	fcc	"2015"

;variaveis			; endereço original
LEVEL	fcb	0		; 18238
LIVES	fcb	5		; 18239
SCORE	fcb	0,0,0,0,0,0	; 18240

TIDELAY	fcb	0		; 18246
TIDEPOS	fcb	0,0		; 18247
WILPOS	fcb	0,0		; 18249
WILSTAT	fcb	0		; 18251
GAMSTAT	fcb	0		; 18252
STONPOS	fcb	0,0		; 18253
SNKTONG	fcb	0,0,0		; 18255,18256,18257
SUNDLAY	fcb	0		; 18258

	fcb	0

STSTATE	fcb	0		; 18260

JUMPING	fcb	0		; 18261
KNSTATE	fcb	0		; 18262
KMSTATE	fcb	0		; 18263
WALKING	fcb	0		; 18264
