        .setcpu 	"6502"
		.localchar	'@'

		.include "../hw.def"
		.include "../sys.def"
		.include "../bios.def"
		
		.include "../CB2k.def"
		.include "system.def"
		.include "electric_duet_player.def"
		
		.org $4000
		
	jsr		SYSTEM_INIT
	
	bit		IS_APPLE2
	bmi		IS_A2
	
IS_TK2K:
	jsr		KEYPRESSED
	beq		:++
	lda		#$1
	sta		TK2K_HW_KEYBOARD_SELECT_EXTRA_ON
	lda		TK2K_HW_KEYBOARD_READ
	sta		TK2K_HW_KEYBOARD_SELECT_EXTRA_OFF
	and		#$01
	beq		:+
	lda		#$80
	.byte	$2C		; BIT abs (ignora a prxima instruo de 2 bytes)
:	lda		#0
:	jsr		MUSIC_INIT	
	jmp		:+
	
IS_A2:
	lda		HW_KEYBOARD_OPENAPPLE
	ora		HW_KEYBOARD_CLOSEDAPPLE
	jsr		MUSIC_INIT
:
	ldy		#CB2K_HANDLER_ERROR
	lda		#<NO_HGR
	ldx		#>NO_HGR
	SYS		CB2K_HANDLER_SET
	
	jsr		SYSTEM_HGR
	SYS		CB2K_FILE_LOAD
	
	PRINT	LISIAS	
	PRINT	ANYKEY
	
	SYS		CB2K_FILE_LOAD
	lda		CB2K_FILE_ADDRESS
	ldx		CB2K_FILE_ADDRESS+1	
	jsr		MUSIC_PLAY
	
	ldy		#CB2K_HANDLER_ERROR
	lda		#<NO_RUN
	ldx		#>NO_RUN
	SYS		CB2K_HANDLER_SET
	SYS		CB2K_FILE_RUN
	
NO_HGR:
	jsr		SYSTEM_TEXT
	PRINT	COPYRIGHT
	rts
NO_RUN:
	jmp		SYSTEM_APPLESOFT_START_COLD
	
LISIAS:
	.byte	20,7
	textz	"http://aboutme.lisias.net"
	.byte 	21,2
	textz	.sprintf("%cTime is the school in which we learn,",'"')
	.byte 	22,5
	textz	.sprintf("Time is the fire in which we burn.%c",'"')
	.byte 	23,23
	textz	"Delmore Schwartz"
	.byte	-1
	
COPYRIGHT:
	.byte	12,9
	textz	"(C) 2012 Lisias Toledo"
	.byte 	14,7
	textz	"http://apple2.lisias.net/"
	.byte	-1
		
ANYKEY:
	.byte	23,0
	textz	"AnyKey:"
	.byte	-1
	
	.include	"system.inc"		
	.include	"electric_duet_player.inc"