        .setcpu 	"6502"
		.localchar	'@'

		.include "../hw.def"
		.include "../sys.def"
		.include "../bios.def"
		
		.include "../CB2k.def"
		.include "system.def"
		
		.org $800
		
		TK2K_UNUSED_START	:=	$400
		TK2K_UNUSED_SIZE	:=	$200
		
		TK2K_BUF_CATALOG	:= TK2K_UNUSED_START + $0300
		TK2K_BUF_TSLIST		:= TK2K_UNUSED_START + $0100
		TK2K_BUF_FILE		:= IOBUFFER
		TK2K_BUF_RWTS		:= TK2K_UNUSED_START + $0280
		

START:		
		jsr		SYSTEM_INIT
		
		; Checa se estamos rodando num TK-2000...
		SYS		CB2K_SYSTEM_IDENTIFICATION
		and		#CB2K_MACHINE_TK2000_GENERIC_MASK
		bne		:+
		jmp		NOT_MY_TARGET
		
:
		SYS		CB2K_CONFIGURATION_GET
		pha
		LOADM	CB2K_CFGBUF_RWTS, #TK2K_BUF_RWTS
		LOADM	CB2K_CFGBUF_CATALOG, #TK2K_BUF_CATALOG
		LOADM	CB2K_CFGBUF_TSLIST, #TK2K_BUF_TSLIST
		LOADM	CB2K_CFGBUF_FILE, #TK2K_BUF_FILE
		pla
		SYS		CB2K_CONFIGURATION_SET
		
EXIT:
		ldy		#CB2K_HANDLER_ERROR
		lda		#<ERROR
		ldx		#>ERROR
		SYS		CB2K_HANDLER_SET
		
		SYS		CB2K_FILE_RUN	; Carrega o prximo programa do catlogo (provavelmente um Menu)
		
ERROR:
		jsr		NO_FUN
		PRINT	MESSAGE_STARTUP_NOT_FOUND
		jmp		SYSTEM_APPLESOFT_START_COLD
	
NOT_MY_TARGET:
		jsr		NO_FUN
		PRINT	MESSAGE_NOT_MY_TARGET
		jsr		ANYKEY
		jmp		EXIT
NO_FUN:
		SYS		CB2K_FINISH		; Desliga o drive - sabe Deus quanto tempo o usurio ficar olhando pra tela!
		jsr		MON_SETTXT
		jsr		HEADER
		jmp		MON_BELL
	
ANYKEY:
		PRINT	ANYKEY_TEXT
		jmp		MON_RDKEY

HEADER:
:		PRINT	HEADER_animation
		dec		HEADER_line_1
		dec		HEADER_line_0
		bmi		:+
		lda		#90
		jsr		MON_WAIT
		beq		:-			; Branch always!	
:		rts

HEADER_animation:
HEADER_line_0:
		.byte	22,0
		textz	"========== CB2k TK2000 System =========="	; 40 chars
HEADER_SIZE := * - HEADER_line_0 + 2
HEADER_line_1:
		.byte	23,0
		textz	"                                        "	; 40 chars
		.byte	1,0,0
		.byte	-1
		
ANYKEY_TEXT:
		.byte	23,0
		textz	"AnyKey to continue:"
		.byte	-1
	
MESSAGE_ERROR:
		.byte	12,7
		textz	"File not found or I/O ERR!"
		.byte	-1
	
MESSAGE_STARTUP_NOT_FOUND:
		.byte	12,2
		textz	"Startup file could not be loaded!"
		.byte	14,2
		textz	"It may be deleted, absent, invalid"
		.byte	15,5
		textz	"or the disk can be damaged..."
		.byte	-1
		
MESSAGE_NOT_NEEDED:
		.byte	12,7
		textz	"Already fits into memory!"
		.byte	-1
		
MESSAGE_NOT_MY_TARGET:
		.byte	12,5
		textz	"Your machine is not supported."
		.byte	-1

		.include	"system.inc"
END:
