        .setcpu 	"6502"
		.localchar	'@'

		.include "../sys.def"
		.include "../hw.def"
		.include "../bios.def"
		
		.include "../CB2k.def"
		
		.org 		$BE00

		PRINT_VECTOR	:= $808

		BUFFER						:=	$26				; buffer
			BUFFERL						:=	BUFFER		; buffer (low)
			BUFFERH						:=	$27			; buffer (high)
		SECTNUM						:=  $1E
		TRCKNUM						:=  $1F
		BOOT0_SECTOR_READ_SECTNUM	:=	$3D				; sector number

		OPCODE_RTS					:= $60
		BOOT1_LOAD_ADDR				:= $0900
		BOOT1_SECTORS_TO_READ		:= $03		;  The first sector is loaded by BOOT0!
		BOOT1_SECTOR_COUNT			:= APPLESOFT_ERRFLG

; =============================================================

PAYLOAD_ADDRESS	:=	$0800
PAYLOAD_COUNT	:=	173

		.CODE
		
		jsr		printit
;:		jmp		:-
		
		; Inicializa rotina de leitura
		
		LOADM	BUFFER, #PAYLOAD_ADDRESS
		LOADMB	BOOT1_SECTOR_COUNT, #PAYLOAD_COUNT
		
		ldx		BOOT0_SLOT16
		lda		HW_DISKII_MOTOR_ON,x		
		
:		jsr		READ_NEXT_SECTOR
		bne		:-
		
		ldx		BOOT0_SLOT16
		lda		HW_DISKII_MOTOR_OFF,x		
		
		jmp		PAYLOAD_ADDRESS
printit:
		LOADAY	#TEXT
		jmp		(PRINT_VECTOR)

READ_NEXT_SECTOR:
	lda		SECTNUM
	clc
	adc		#2
	
	cmp		#$11
	bcc		:++
	
	; Advance one track
	inc		BOOT0_TRACK
	ldy		#2
:
	lda		TRCKNUM
	pha
	inc		TRCKNUM
	lda		TRCKNUM
	jsr		stepper_on
	pla
	jsr		stepper_off
	dey
	bne 	:-
	lda		#0
:
	cmp		#$10
	bcc		:+
	lda		#1
:
	sta		SECTNUM
	sta		BOOT0_SECTOR_READ_SECTNUM
	ldx		BOOT0_SLOT16
	jsr		BOOT0_SECTOR_READ_SECTOR
	dec		BOOT1_SECTOR_COUNT
	rts
	
stepper_on:
		sec
        .byte   $24		; BIT ZP - this "force a ignore" on the next 1 byte instruction
stepper_off:
		clc
		php
		and     #$03
        asl     a
		plp
        ora     BOOT0_SLOT16
        tax
		bcc		:+
		inx		; Truquezinho sujo. Aproveitamos que a diferena entre o ON e o OFF  de um byte no endereo!
:       lda     HW_DISKII_PHASE_0_OFF,x
		lda		#86							; WAIT 19.2 MILLISECONDS
		jmp 	MON_WAIT					; NO CHANGE TO X OR Y, A=0
		
BOOT0_SECTOR_READ_SECTOR:
LC15C:
		clc
LC15D:  php
LC15E:  lda     $C08C,x
        bpl     LC15E
LC163:  eor     #$D5
        bne     LC15E
LC167:  lda     $C08C,x
        bpl     LC167
        cmp     #$AA
        bne     LC163
        nop
LC171:  lda     $C08C,x
        bpl     LC171
        cmp     #$96
        beq     LC183
        plp
        bcc     LC15C
        eor     #$AD
        beq     LC1A6
        bne     LC15C
LC183:  ldy     #$03
LC185:  sta     $40
LC187:  lda     $C08C,x
        bpl     LC187
        rol     a
        sta     $3C
LC18F:  lda     $C08C,x
        bpl     LC18F
        and     $3C
        dey
        bne     LC185
        plp
        cmp     $3D
        bne     LC15C
        lda     $40
        cmp     $41
        bne     LC15C
        bcs     LC15D
LC1A6:  ldy     #$56
LC1A8:  sty     $3C
LC1AA:  ldy     $C08C,x
        bpl     LC1AA
        eor     $02D6,y
        ldy     $3C
        dey
        sta     $0300,y
        bne     LC1A8
LC1BA:  sty     $3C
LC1BC:  ldy     $C08C,x
        bpl     LC1BC
        eor     $02D6,y
        ldy     $3C
        sta     ($26),y
        iny
        bne     LC1BA
LC1CB:  ldy     $C08C,x
        bpl     LC1CB
        eor     $02D6,y
LC1D3:  bne     LC15C
        ldy     #$00
LC1D7:  ldx     #$56
LC1D9:  dex
        bmi     LC1D7
        lda     ($26),y
        lsr     $0300,x
        rol     a
        lsr     $0300,x
        rol     a
        sta     ($26),y
        iny
        bne     LC1D9
        inc     $27
        inc     $3D
		rts
TEXT:
	.byte 	12,10
	textz 	"Montezuma's Revenge"
	.byte 	14,15
	textz	"2012.0831"
	.byte 	23,5
	textz	"http://tk2k.lisias.net/library"
	.byte	-1


.end

