' WAV2BIN.
'
' WAV2BIN.EXE le um arquivo .WAV, identifica nele um arquivo salvo em formato
' sonoro pelo microcomputador MC 1000 (para armazenamento em fita cassete) e
' extrai os bytes assim codificados em um arquivo .BIN.

DECLARE SUB obtemnomesarq (nomearqwav AS STRING, nomearqbin AS STRING)
DECLARE SUB abrearqwav (nomearqwav AS STRING, w AS ANY)
DECLARE SUB lepulso (w AS ANY, p AS ANY)
DECLARE FUNCTION fimdasamostras% (w AS ANY)
DECLARE FUNCTION leamostra% (w AS ANY)
DECLARE FUNCTION lebyte% (w AS ANY)

' Tipos definidos para a leitura de arquivo WAV, conforme
' http://ccrma.stanford.edu/courses/422/projects/WaveFormat/

TYPE wavchunk
   id AS STRING * 4
   size AS LONG
   format AS STRING * 4
END TYPE

TYPE wavsubchunk
   id AS STRING * 4
   size AS LONG
END TYPE

TYPE wavfmtsubchunk
   audioformat AS INTEGER
   numchannels AS INTEGER
   samplerate AS LONG
   byterate AS LONG
   blockalign AS INTEGER
   bitspersample AS INTEGER
   extraparamsize AS INTEGER
END TYPE

' Outros tipos.

TYPE wavfile
   posleitura AS LONG
   c AS wavchunk
   sc AS wavsubchunk
   fsc AS wavfmtsubchunk
   pulsoporamostra AS DOUBLE
   posiniciodasamostras AS LONG
   posfimdasamostras AS LONG
END TYPE

TYPE pulso
   comprimento AS DOUBLE
   curto AS INTEGER
   longo AS INTEGER
   bit0 AS INTEGER
   bit1 AS INTEGER
END TYPE

DIM nomearqwav AS STRING
DIM nomearqbin AS STRING
DIM nomearqtxt AS STRING
DIM w AS wavfile
DIM p AS pulso
DIM n AS INTEGER
DIM byte AS INTEGER
DIM nomearq AS STRING
DIM enderecoinicio AS LONG
DIM enderecoaposfim AS LONG

obtemnomesarq nomearqwav, nomearqbin
abrearqwav nomearqwav, w

' O arquivo sonoro gerado pelo MC 1000 se inicia com uma sequencia de
' 512 pulsos curtos (bits 1) e 256 pulsos longos (bits 0).
' O MC 1000 le alguns desses pulsos (64 de cada) para reconhecer o
' inicio do arquivo e se ajustar `a velocidade do toca-fitas.
' Aqui usamo-los apenas para reconhecer o inicio do arquivo.
' Nenhum ajuste e' feito.

' Le uma sequencia de 64 bits 1.
FOR n = 1 TO 64
   IF fimdasamostras(w) THEN END
   lepulso w, p
   IF NOT p.bit1 THEN n = 0 ' Reinicia contagem.
NEXT n
PRINT ">>> Lidos 64 bits 1."
 
' Le uma sequencia de 64 bits 0.
FOR n = 1 TO 64
   IF fimdasamostras(w) THEN END
   lepulso w, p
   IF NOT p.bit0 THEN n = 0 ' Reinicia contagem.
NEXT n
PRINT ">>> Lidos 64 bits 0."

' Apaga o conteudo do arquivo binario, se ja existir.
OPEN nomearqbin FOR OUTPUT AS #2
CLOSE #2

' Abre arquivo binario.
OPEN nomearqbin FOR BINARY AS #2

' Le o nome do arquivo do MC 1000.
' 14 caracteres ou menos.
' Se menos, termina com CR.
nomearq = ""
FOR n = 1 TO 14
   byte = lebyte(w)
   IF byte = 13 THEN EXIT FOR
   nomearq = nomearq + CHR$(byte)
NEXT
PRINT ">>> Lido nome do arquivo: '"; nomearq; "'"

' Le o endereco de inicio do bloco.
enderecoinicio = lebyte(w) + 256 * lebyte(w)
PRINT ">>> Lido endereco de inicio do bloco: "; RIGHT$("000" + HEX$(enderecoinicio), 4)

' Le o endereco de fim do bloco.
enderecoaposfim = lebyte(w) + 256 * lebyte(w)
PRINT ">>> Lido endereco seguinte ao fim do bloco: "; RIGHT$("000" + HEX$(enderecoaposfim), 4)

' Le o bloco de dados propriamente dito.
FOR n = 1 TO enderecoaposfim - enderecoinicio + 1
   byte = lebyte(w)
NEXT
PRINT ">>> Fim do arquivo do MC 1000."

' Le o restante do arquivo, sem processar nada.
DO WHILE NOT fimdasamostras(w)
   n = leamostra(w)
LOOP

' Fecha arquivos e termina.
CLOSE
END

' Le as porcoes do arquivo WAV e sua formatacao interna.
SUB abrearqwav (nomearqwav AS STRING, w AS wavfile)
   OPEN nomearqwav FOR BINARY AS #1

   w.posleitura = 1
   GET #1, w.posleitura, w.c
   w.posleitura = w.posleitura + LEN(w.c)

   IF w.c.id <> "RIFF" AND w.c.format <> "WAVE" THEN
      PRINT ">>> Arquivo nao parece ser do tipo WAV."
      END
   END IF

   PRINT ">>> Arquivo: "; nomarqwav
   PRINT ">>> Tamanho: "; w.c.size

   DO WHILE w.posleitura <= w.c.size
      GET #1, w.posleitura, w.sc
      w.posleitura = w.posleitura + LEN(w.sc)

      SELECT CASE w.sc.id
      CASE "fmt "
         GET #1, w.posleitura, w.fsc
         w.posleitura = w.posleitura + w.sc.size

         PRINT ">>> AudioFormat: "; w.fsc.audioformat
         PRINT ">>> NumChannels: "; w.fsc.numchannels
         PRINT ">>> SampleRate: "; w.fsc.samplerate
         PRINT ">>> ByteRate: "; w.fsc.byterate
         PRINT ">>> BlockAlign: "; w.fsc.blockalign
         PRINT ">>> BitsPerSample: "; w.fsc.bitspersample

         w.pulsoporamostra = 44100# / 16# / w.fsc.samplerate
         PRINT ">>> pulsoporamostra: "; w.pulsoporamostra

      CASE "data"
         w.posiniciodasamostras = w.posleitura
         w.posleitura = w.posleitura + w.sc.size
         w.posfimdasamostras = w.posleitura - 1

      CASE ELSE
         w.posleitura = w.posleitura + w.sc.size

      END SELECT
   LOOP

   w.posleitura = w.posiniciodasamostras
END SUB

FUNCTION fimdasamostras% (w AS wavfile)
   fimdasamostras% = (w.posleitura > w.posfimdasamostras)
END FUNCTION

' Le o canal 1 da amostra atual e avanca para a amostra
' seguinte, ignorando os demais canais.
FUNCTION leamostra% (w AS wavfile)
   DIM word AS INTEGER
   DIM byte AS STRING * 1

   IF NOT fimdasamostras(w) THEN
      SELECT CASE w.fsc.bitspersample
      CASE 8
         GET #1, w.posleitura, byte
         word = (ASC(byte) - 128) * 256
      CASE 16
         GET #1, w.posleitura, word
      END SELECT
      PRINT TAB(25 + word * 25! / 32768); "#"; TAB(51); word; "@"; w.posleitura
      leamostra% = word
      w.posleitura = w.posleitura + w.fsc.blockalign
   ELSE
      leamostra% = 0
   END IF
END FUNCTION

' Le um bit 1 (marca de inicio),
' seguido pelos 8 bits do byte
' (do menos ao mais significativo)
' e depois um bit de paridade.
FUNCTION lebyte% (w AS wavfile)
   DIM p AS pulso
   DIM byte AS INTEGER
   DIM caracter AS STRING * 1
   DIM bit AS INTEGER
   DIM paridadepar AS INTEGER

   byte = 0
   paridadepar = NOT 0

   DO
      IF fimdasamostras(w) THEN END
      lepulso w, p
   LOOP UNTIL p.bit1
   PRINT ">>> Lida marca de inicio de byte."

   IF fimdasamostras(w) THEN END
   FOR bit = 0 TO 7
      IF fimdasamostras(w) THEN EXIT FOR
      lepulso w, p
      IF p.curto THEN
         byte = byte + 2 ^ bit
         paridadepar = NOT paridadepar
      END IF
   NEXT
   PRINT ">>> Lido byte: "; RIGHT$("0" + HEX$(byte), 2)
   lebyte% = byte
   caracter = CHR$(byte)
   PUT #2, LOF(2) + 1, caracter

   IF fimdasamostras(w) THEN END
   lepulso w, p
   PRINT ">>> Lido bit de paridade."
   IF (paridadepar <> p.curto) THEN
      PRINT ">>> Erro de paridade."
      PRINT ">>> 'REBOBINE A FITA E REAPERTE O BOTAO PLAY.'"
      END
   END IF
END FUNCTION

' Salta um pulso baixo (se houver)
' e le um pulso alto do arquivo wave,
' anotando seu comprimento.
SUB lepulso (w AS wavfile, p AS pulso)
   ' O valor do comprimento e proporcional a duracao
   ' de um pulso curto (aprox. 3,62810^-4 segundos):
   ' 1 = a duracao de um pulso curto (bit 1).
   ' 2 = a duracao de um pulso longo (o dobro do curto) (bit 0).

   ' As constantes definidas abaixo determinam
   ' tolerancias para reconhecer bits 1 e 0 no
   ' momento da leitura:
   ' De 0,7 a 1,4 = pulso curto (bit 1).
   ' De 1,4 a 2,8 = pulso longo (bit 0).

   CONST limiteinferior = .7071067811865476# ' 2^-0.5
   CONST limiteinterno = 1.414213562373095# ' 2^0.5
   CONST limitesuperior = 2.82842712474619# ' 2^1.5

   DIM amostra AS INTEGER

   p.comprimento = 0

   ' Salta pulso baixo.
   DO WHILE NOT fimdasamostras(w)
      amostra = leamostra(w)
      IF amostra > 0 THEN
         p.comprimento = w.pulsoporamostra
         EXIT DO
      END IF
   LOOP

   ' Le pulso alto.
   DO WHILE NOT fimdasamostras(w)
      amostra = leamostra(w)
      IF amostra > 0 THEN
         p.comprimento = p.comprimento + w.pulsoporamostra
      ELSE
         EXIT DO
      END IF
   LOOP

   p.curto = p.comprimento < limiteinterno
   p.longo = NOT p.curto
   p.bit0 = p.longo AND (p.comprimento < limitesuperior)
   p.bit1 = p.curto AND (p.comprimento >= limiteinferior)
END SUB

SUB obtemnomesarq (nomearqwav AS STRING, nomearqbin AS STRING)
   DIM argumentos AS STRING
   DIM posicaoespaco AS INTEGER

   ' Analisa a linha de comando para obter o nome do arquivo .WAV.
   argumentos = LTRIM$(COMMAND$)
   posicaoespaco = INSTR(argumentos, " ")
   IF posicaoespaco = 0 THEN
      nomearqwav = argumentos
   ELSE
      nomearqwav = LEFT$(argumentos, posicaoespaco - 1)
   END IF

   IF RIGHT$(nomearqwav, 4) = ".WAV" AND LEN(nomearqwav) > 4 THEN
      ' Calcula a partir do nome do arquivo .WAV o nome do arquivo
      ' binario de saida, substituindo sua extensao por .BIN.
      nomearqbin = LEFT$(nomearqwav, LEN(nomearqwav) - 4) + ".BIN"

   ELSE
      ' Acusa uso incorreto.
      COLOR 7
      PRINT
      PRINT "Uso:"
      COLOR 15
      PRINT "   wav2bin nomedoarquivo.wav"
      COLOR 7
      PRINT
      PRINT "WAV2BIN.EXE le um arquivo .WAV, identifi";
      PRINT "ca nele um arquivo salvo em formato"
      PRINT "sonoro pelo microcomputador MC 1000 (par";
      PRINT "a armazenamento em fita cassete) e"
      PRINT "extrai os bytes assim codificados em um ";
      PRINT "arquivo .BIN."
      PRINT
      PRINT "Para acelerar o processamento, a impress";
      PRINT "ao do progresso da analise pode ser"
      PRINT "redirecionada da tela para um arquivo ad";
      PRINT "icionando-se:"
      COLOR 15
      PRINT "   > arquivo.txt"
      COLOR 7
      PRINT "apos o comando; ou ser totalmente suprim";
      PRINT "ida adicionando-se:"
      COLOR 15
      PRINT "   > nul"
      COLOR 7
      PRINT
      PRINT "Para maiores informacoes, consulte"
      PRINT "http://www.seedwiki.com/wiki/mc-1000/cassete"
      PRINT
      END
   END IF
END SUB

