' BAS2BIN.
'
' BAS2BIN.EXE le um arquivo .BAS ou .TXT contendo um programa em BASIC
' e o converte em um arquivo .BIN com a sequencia de bytes correspondente
' `a representacao desse programa na memoria do microcomputador MC 1000.

DECLARE SUB obtemnomesarq (nomearqbas AS STRING, nomearqbin AS STRING)
DECLARE FUNCTION uint% (x AS LONG)

DIM palavrareservada(128 TO 223) AS STRING
DIM nomearqbas AS STRING
DIM nomearqbin AS STRING
DIM nomearq AS STRING * 5
DIM enderecoinicio AS LONG
DIM enderecoaposfim AS LONG
DIM enderecoproxlinha AS LONG
DIM status AS INTEGER
DIM linhabas AS STRING
DIM linhabin AS STRING
DIM numlinha AS LONG
DIM caracter AS STRING * 1
DIM n AS INTEGER
DIM token AS INTEGER
DIM endereco AS INTEGER

FOR n = 128 TO 223
   READ palavrareservada(n)
NEXT

DATA "END", "FOR", "NEXT", "DATA", "EXIT", "INPUT", "DIM", "READ"
DATA "LET", "GOTO", "RUN", "IF", "RESTORE", "GOSUB", "RETURN", "REM"
DATA "STOP", "OUT", "ON", "HOME", "WAIT", "DEF", "POKE", "PRINT"
DATA "PR#", "SOUND", "GR", "HGR", "COLOR", "TEXT", "PLOT", "TRO"
DATA "UNPLOT", "SET", "CALL", "DRAW", "UNDRAW", "TEMPO", "WIDTH", "CONT"
DATA "LIST", "CLEAR", "LOAD", "SAVE", "NEW", "TLOAD", "COLUMN", "AUTO"
DATA "FAST", "SLOW", "EDIT", "INVERSE", "NORMAL", "DEBUG", "TAB(", "TO"
DATA "FN", "SPC(", "THEN", "NOT", "STEP", "VTAB(", "+", "-"
DATA "*", "/", "^", "AND", "OR", ">", "=", "<"
DATA "SGN", "INT", "ABS", "USR", "FRE", "INP", "POS", "SQR"
DATA "RND", "LOG", "EXP", "COS", "SIN", "TAN", "ATN", "PEEK"
DATA "LEN", "STR$", "VAL", "ASC", "CHR$", "LEFT$", "RIGHT$", "MID$"

obtemnomesarq nomearqbas, nomearqbin

OPEN nomearqbas FOR INPUT AS #1

OPEN nomearqbin FOR OUTPUT AS #2
CLOSE #2
OPEN nomearqbin FOR BINARY AS #2

nomearq = "    "
PUT #2, 1, nomearq
caracter = CHR$(13)
PUT #2, 6, caracter
enderecoinicio = &H3D5
endereco = uint(enderecoinicio)
PUT #2, 7, endereco
enderecoaposfim = 0 ' A definir.
endereco = uint(enderecoaposfim)
PUT #2, 9, endereco

enderecoproxlinha = enderecoinicio
DO WHILE NOT EOF(1)
   LINE INPUT #1, linhabas
   linhabas = UCASE$(LTRIM$(RTRIM$(linhabas)))
   PRINT linhabas
   linhabin = ""
   numlinha = 0
   status = 0
   DO WHILE linhabas <> ""
      SELECT CASE status
      CASE 0
         ' Inicio do numero de linha.
         caracter = LEFT$(linhabas, 1)
         IF caracter >= "0" AND caracter <= "9" THEN
            numlinha = VAL(caracter)
            linhabas = MID$(linhabas, 2)
            status = 1
         ELSE
            PRINT ">>> Linha ignorada: Numero de linha ausente."
            EXIT DO
         END IF
      CASE 1
         ' Resto do numero de linha.
         caracter = LEFT$(linhabas, 1)
         IF caracter >= "0" AND caracter <= "9" THEN
            numlinha = numlinha * 10 + VAL(caracter)
            IF numlinha > 65535 THEN
               PRINT ">>> Linha ignorada: Numero de linha superior a 65535."
               EXIT DO
            END IF
            linhabas = MID$(linhabas, 2)
         ELSE
            linhabin = CHR$(numlinha AND 255) + CHR$(INT(numlinha / 256))
            status = 2
         END IF
      CASE 2
         ' Conteudo normal da linha.
         linhabas = LTRIM$(linhabas)
         caracter = LEFT$(linhabas, 1)
         IF caracter = CHR$(34) THEN
            linhabin = linhabin + caracter
            linhabas = MID$(linhabas, 2)
            status = 3
         ELSE
            token = 0
            FOR n = LBOUND(palavrareservada) TO UBOUND(palavrareservada)
               IF LEFT$(linhabas, LEN(palavrareservada(n))) = palavrareservada(n) THEN
                  token = n
                  EXIT FOR
               END IF
            NEXT
            IF token <> 0 THEN
               linhabin = linhabin + CHR$(token)
               linhabas = LTRIM$(MID$(linhabas, LEN(palavrareservada(token)) + 1))
               SELECT CASE palavrareservada(token)
               CASE "REM"
                  status = 4
               CASE "DATA"
                  status = 5
               END SELECT
            ELSE
               linhabin = linhabin + caracter
               linhabas = MID$(linhabas, 2)
            END IF
         END IF
      CASE 3
         ' String.
         caracter = LEFT$(linhabas, 1)
         linhabin = linhabin + caracter
         linhabas = MID$(linhabas, 2)
         IF caracter = CHR$(34) THEN
            status = 2
         END IF
      CASE 4
         ' REM.
         linhabin = linhabin + linhabas
         linhabas = ""
      CASE 5
         ' DATA.
         caracter = LEFT$(linhabas, 1)
         linhabin = linhabin + caracter
         linhabas = MID$(linhabas, 2)
         IF caracter = ":" THEN
            status = 2
         ELSEIF caracter = CHR$(34) THEN
            status = 6
         END IF
      CASE 6
         ' String em DATA.
         caracter = LEFT$(linhabas, 1)
         linhabin = linhabin + caracter
         linhabas = MID$(linhabas, 2)
         IF caracter = CHR$(34) THEN
            status = 5
         END IF
      END SELECT
   LOOP
   IF linhabin <> "" THEN
      linhabin = linhabin + CHR$(0)
      enderecoproxlinha = enderecoproxlinha + LEN(linhabin) + 2
      endereco = uint(enderecoproxlinha)
      PUT #2, LOF(2) + 1, endereco
      PUT #2, LOF(2) + 1, linhabin
   END IF
LOOP
' Fim do programa BASIC.
endereco = uint(0)
PUT #2, LOF(2) + 1, endereco

' Completa registro.
enderecoaposfim = enderecoproxlinha + 2
endereco = uint(enderecoaposfim)
PUT #2, 9, endereco

' Fecha arquivos e termina.
CLOSE
END

SUB obtemnomesarq (nomearqbas AS STRING, nomearqbin AS STRING)
   DIM argumentos AS STRING
   DIM posicaoespaco AS INTEGER

   ' Analisa a linha de comando para obter o nome do arquivo .WAV.
   argumentos = LTRIM$(COMMAND$)
   posicaoespaco = INSTR(argumentos, " ")
   IF posicaoespaco = 0 THEN
      nomearqbas = argumentos
   ELSE
      nomearqbas = LEFT$(argumentos, posicaoespaco - 1)
   END IF

   IF (RIGHT$(nomearqbas, 4) = ".BAS" OR RIGHT$(nomearqbas, 4) = ".TXT") AND LEN(nomearqbas) > 4 THEN
      ' Calcula a partir do nome do arquivo .WAV o nome do arquivo
      ' binario de saida, substituindo sua extensao por .BIN.
      nomearqbin = LEFT$(nomearqbas, LEN(nomearqbas) - 4) + ".BIN"

   ELSE
      ' Acusa uso incorreto.
      COLOR 7
      PRINT
      PRINT "Uso:"
      COLOR 15
      PRINT "   bas2bin nomedoarquivo.bas"
      COLOR 7
      PRINT "ou"
      COLOR 15
      PRINT "   bas2bin nomedoarquivo.txt"
      COLOR 7
      PRINT
      PRINT "BAS2BIN.EXE le um arquivo .BAS ou .TXT c";
      PRINT "ontendo um programa em BASIC e o"
      PRINT "converte em um arquivo .BIN com a sequen";
      PRINT "cia de bytes correspondente `a"
      PRINT "representacao desse programa na memoria ";
      PRINT "do microcomputador MC 1000."
      PRINT
      PRINT "Para maiores informacoes, consulte"
      PRINT "http://www.seedwiki.com/wiki/mc-1000"
      PRINT
      END
   END IF
END SUB

FUNCTION uint% (x AS LONG)
   uint% = x - (65536 AND x > 32767)
END FUNCTION

