' LISTBIN.
'
' LISTBIN.EXE le um arquivo .BIN contendo um programa em BASIC do MC 1000
' e reproduz o efeito do comando LIST.

DECLARE SUB obtemnomearq (nomearqbin AS STRING)
DECLARE FUNCTION lebyte% ()

DIM palavrareservada(128 TO 223) AS STRING
DIM n AS INTEGER
DIM nomearqbin AS STRING
DIM posleitura AS LONG
DIM byte AS INTEGER
DIM nomearq AS STRING
DIM enderecoinicio AS LONG
DIM enderecoaposfim AS LONG
DIM enderecoproxlinha AS LONG
DIM numlinha AS LONG

FOR n = 128 TO 223
   READ palavrareservada(n)
NEXT

DATA "END", "FOR", "NEXT", "DATA", "EXIT", "INPUT", "DIM", "READ"
DATA "LET", "GOTO", "RUN", "IF", "RESTORE", "GOSUB", "RETURN", "REM"
DATA "STOP", "OUT", "ON", "HOME", "WAIT", "DEF", "POKE", "PRINT"
DATA "PR#", "SOUND", "GR", "HGR", "COLOR", "TEXT", "PLOT", "TRO"
DATA "UNPLOT", "SET", "CALL", "DRAW", "UNDRAW", "TEMPO", "WIDTH", "CONT"
DATA "LIST", "CLEAR", "LOAD", "SAVE", "NEW", "TLOAD", "COLUMN", "AUTO"
DATA "FAST", "SLOW", "EDIT", "INVERSE", "NORMAL", "DEBUG", "TAB(", "TO"
DATA "FN", "SPC(", "THEN", "NOT", "STEP", "VTAB(", "+", "-"
DATA "*", "/", "^", "AND", "OR", ">", "=", "<"
DATA "SGN", "INT", "ABS", "USR", "FRE", "INP", "POS", "SQR"
DATA "RND", "LOG", "EXP", "COS", "SIN", "TAN", "ATN", "PEEK"
DATA "LEN", "STR$", "VAL", "ASC", "CHR$", "LEFT$", "RIGHT$", "MID$"

obtemnomearq nomearqbin

OPEN nomearqbin FOR BINARY AS #1

' Le o nome do arquivo do MC 1000.
' 14 caracteres ou menos.
' Se menos, termina com CR.
nomearq = ""
posleitura = 1
DO WHILE posleitura <= 14
   byte = lebyte
   IF byte = 13 THEN EXIT DO
   nomearq = nomearq + CHR$(byte)
LOOP
PRINT ">>> Lido nome do arquivo: '"; nomearq; "'"

' Le o endereco de inicio do bloco.
enderecoinicio = lebyte + 256 * lebyte
PRINT ">>> Lido endereco de inicio do bloco: "; RIGHT$("000" + HEX$(enderecoinicio), 4)

' Le o endereco de fim do bloco.
enderecoaposfim = lebyte + 256 * lebyte
PRINT ">>> Lido endereco seguinte ao fim do bloco: "; RIGHT$("000" + HEX$(enderecoaposfim), 4)

' Le o bloco de dados propriamente dito (programa BASIC).
DO
   enderecoproxlinha = lebyte + 256 * lebyte
   IF enderecoproxlinha = 0 THEN
      ' Fim de programa.
      EXIT DO
   END IF
   numerolinha = lebyte + 256 * lebyte
   PRINT LTRIM$(STR$(numerolinha)); " ";
   DO
      byte = lebyte
      IF byte = 0 THEN
         ' Fim de linha.
         PRINT
         EXIT DO
      END IF
      IF byte < 128 THEN
         ' Caracter comum.
         PRINT CHR$(byte);
      ELSE
         ' 'Token' de palavra reservada.
         PRINT " "; palavrareservada(byte); " ";
      END IF
   LOOP
LOOP

' Fecha arquivos e termina.
CLOSE
END

FUNCTION lebyte%
   SHARED posleitura AS LONG
   DIM byte AS STRING * 1

   IF posleitura > LOF(1) THEN
      PRINT ">>> Fim de arquivo inesperado."
      END
   END IF

   GET #1, posleitura, byte
   posleitura = posleitura + 1
   lebyte = ASC(byte)
END FUNCTION

SUB obtemnomearq (nomearqbin AS STRING)
   DIM argumentos AS STRING
   DIM posicaoespaco AS INTEGER

   ' Analisa a linha de comando para obter o nome do arquivo .WAV.
   argumentos = LTRIM$(COMMAND$)
   posicaoespaco = INSTR(argumentos, " ")
   IF posicaoespaco = 0 THEN
      nomearqbin = argumentos
   ELSE
      nomearqbin = LEFT$(argumentos, posicaoespaco - 1)
   END IF

   IF RIGHT$(nomearqbin, 4) <> ".BIN" OR LEN(nomearqbin) <= 4 THEN
      ' Acusa uso incorreto.
      COLOR 7
      PRINT
      PRINT "Uso:"
      COLOR 15
      PRINT "   listbin nomedoarquivo.bin"
      COLOR 7
      PRINT
      PRINT "LISTBIN.EXE le um arquivo .BIN contendo ";
      PRINT "um programa em BASIC do MC 1000 e"
      PRINT "reproduz o efeito do comando LIST."
      PRINT
      PRINT "Para maiores informacoes, consulte"
      PRINT "http://www.seedwiki.com/wiki/mc-1000"
      PRINT
      END
   END IF
END SUB

