{**********************************************************************}
{*                              T Y P M P                             *}
{*--------------------------------------------------------------------*}
{*    Description    : Sets the key repeat rate of the AT keyboard.   *}
{*--------------------------------------------------------------------*}
{*    Author         : MICHAEL TISCHER                                *}
{*    developed on   : 08/27/1988                                     *}
{*    last update    : 08/27/1988                                     *}
{**********************************************************************}

program TYPMP;

{**********************************************************************}
{* SetTypm: Sends the key repeat rate to the keyboard controller      *}
{* Input  : RATE : the repeat rate to be set                          *}
{* Output : TRUE, if the value was set, FALSE if an error occurred    *}
{*          accessing the controller                                  *}
{* Info   : This function can be bound into a UNIT                    *}
{**********************************************************************}

{$F+}                          { this function uses the FAR call model }

function SetTypm( Rate : byte ) : boolean;

begin
 inline(
        $32/$D2/$B4/$F3/$FA/$E8/$13/$00/$75/$0A/$8A/$66/$06/$E8/
        $0B/$00/$75/$02/$FE/$C2/$FB/$88/$56/$FF/$EB/$27/$90/$51/
        $53/$B3/$03/$33/$C9/$E4/$64/$A8/$02/$E0/$FA/$8A/$C4/$E6/
        $60/$E4/$64/$A8/$01/$E1/$FA/$E4/$60/$3C/$FA/$74/$07/$FE/
        $CB/$75/$E6/$80/$CB/$01/$5B/$59/$C3
       );
end;

{$F-}

{**********************************************************************}
{**                           MAIN PROGRAM                           **}
{**********************************************************************}

var  Delay,                                         { stores the delay }
     Speed,                               { stores the key repeat rate }
     Fpos1,
     FPos2   : integer;          { error position in string conversion }
     ParErr : boolean;                    { error in parameter passing }

begin
  writeln(#13#10,'TYPMP  -  (c) 1988 by MICHAEL TISCHER');
  ParErr := true;                         { assume error in parameters }
  if ParamCount = 2 then                   { were 2 parameters passed? }
    begin                                                        { YES }
      val(ParamStr(1), Delay, FPos1);     { first parameter to integer }
      val(ParamStr(2), Speed, FPos2);    { second parameter to integer }
      if ((FPos1=0) and (FPos2=0)) then         { error in conversion? }
        if ((Delay < 4) and (Speed <32)) then          { no, value OK? }
          ParErr := false;               { yes, then parameters are OK }
    end;
  if ( ParErr ) then                              { are parameters OK? }
    begin                                                         { no }
      writeln('Call  : TYPMP       delay     key_repeat_rate');
      writeln('                     ',#30,'              ',#30);
      writeln('                                   ');
      writeln('     Ŀ  Ŀ');
      writeln('       0 : 1/4 second       0 : 30.0 rep./s. ');
      writeln('       1 : 1/2 second       1 : 26.7 rep./s. ');
      writeln('       2 : 3/4 second       2 : 24.0 rep./s. ');
      writeln('       3 : 1 second         3 : 21.8 rep./s. ');
      writeln('     Ĵ           .         ');
      writeln('      all values   q20%            .         ');
      writeln('                .         ');
      writeln('                             28 :  2.5 rep./s. ');
      writeln('                             29 :  2.3 rep./s. ');
      writeln('                             30 :  2.1 rep./s. ');
      writeln('                             31 :  2.0 rep./s. ');
      writeln('                            ');
    end
  else                                         { the parameters are OK }
  begin
    if (SetTypm( (Delay shl 5) + Speed )) then   { set key repeat rate }
      writeln('The keboard repeat rate was set.')
    else
      writeln('ERROR accessing the keyboard controller.');
  end;
end.
