{$V-}                                  { don't check length of strings }

{**********************************************************************}
{*                              E G A P                               *}
{*--------------------------------------------------------------------*}
{*    Description    : demonstrates the use of the functions of the   *}
{*                     EGA/VGA BIOS.                                  *}
{*--------------------------------------------------------------------*}
{*    Author         : MICHAEL TISCHER                                *}
{*    developed on   : 08/30/1988                                     *}
{*    last update    : 06/07/1989                                     *}
{**********************************************************************}

program EGAVGAP;

Uses Dos, CRT;                         { bind in the DOS and CRT units }
type  BytePtr = ^byte;                             { pointer to a byte }

      VElb = record           { describes a screen position as 2 bytes }

               Character : char;                    { the   ASCII code }
               Attribute : byte;                       { the attribute }
               end;
      VRam  = array[0..4000] of VelB;        { describes the video RAM }
      string8 = string[80];                { output string for PrintAt }

const VIDEO_INT = $10;                          { BIOS video interrupt }
      LINE25    = 25;                                 { 25 line screen }
      LINE43    = 43;                                 { 43 line screen }
      MOMO      = 0;                         { constants for GetMonTyp }
      COLOR     = 1;
      EGA       = 2;
      Font : array[1..120, 1..14] of byte = (
      (  0,  0,255, 62, 28, 28, 28, 28, 28, 28, 28, 28, 28, 31),   { E }
      (  0,  0,252,  7,  1,  1,  1,  1,  1,  1,  1,  1,  7,252),   { A }
      (  0,  0,  0,  0,129,195,195,199,199,206,206,142, 14, 14),   { C }
      (  0,  0, 62,193,128,128,  0,  0,  0,  0,  0,  0,  0,  0),   { H }
      (  0,  0, 16,144,112, 48, 48, 16, 16,  0,  0,  0,  0,  0),   {   }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),   { L }
      (  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),   { I }
      (  0,  0,254,248,112,112,112,112,112,112,112,112,112,112),   { N }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,252, 61, 30, 30, 28),   { E }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,248,  6,  7,  3,  3),   {   }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  7,  0,  0,  0,128),   { C }
      (  0,  0, 32, 96,224,224,224,224,224,254,224,224,224,224),   { O }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  6, 12, 28, 24),   { N }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,240, 28,  6,  7,  7),   { T }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0, 63, 15,  7,  7,  7),   { A }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0, 30, 39, 71,135,128),   { I }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,126, 30, 15, 15, 14),   { N }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,124,131,  3,  1,  1),   { S }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,129,131,195),   {   }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 62,193,128,  0),   { T }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,192,224,224),   { H }
      (  0,  0,248,120, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56),   { E }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0, 31, 48, 48, 48, 48),   {   }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,196, 52, 12,  4,  4),   { B }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),   { I }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),   { T }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),   {   }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),   { P }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),   { A }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),   { T }
      ( 28, 28, 28, 28, 28, 28, 28, 28, 62,255,  0,  0,  0,  0),   { T }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,128,  0,  0,  0,  0),   { E }
      ( 14, 14, 14,  7,  7,  3,  3,  1,  0,  0,  0,  0,  0,  0),   { R }
      (  0,  0,  0,  0,  0,  0,128,128,193, 62,  0,  0,  0,  0),   { N }
      (  0,  0,  0,  0, 16, 16, 32, 64,128,  0,  0,  0,  0,  0),   {   }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),   { O }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0,  0,  0),   { F }
      (112,112,112,112,112,112,112,112,248,254,  0,  0,  0,  0),   {   }
      ( 28, 28, 28, 28, 28, 28, 28, 28, 62,255,  0,  0,  0,  0),   { A }
      (  3,  3,  3,  3,  3,  3,  3,  3,  7,159,  0,  0,  0,  0),   {   }
      (128,128,128,128,128,128,128,128,192,240,  0,  0,  0,  0),   { C }
      (224,224,224,224,224,224, 96,112, 49, 30,  0,  0,  0,  0),   { H }
      ( 56, 63, 56, 56, 56, 24, 92, 76,134,  1,  0,  0,  0,  0),   { A }
      (  7,255,  0,  0,  0,  0,  1,  2, 12,240,  0,  0,  0,  0),   { R }
      (  7,  7,  7,  7,  7,  7,  7,  7, 15, 63,  0,  0,  0,  0),   { A }
      (  0,  0,  0,  0,  0,  0,  0,  0,128,224,  0,  0,  0,  0),   { C }
      ( 14, 14, 14, 14, 14, 14, 14, 14, 31,127,  0,  0,  0,  0),   { T }
      (  1,  1,  1,  1,  1,  1,  1,  1,  3,207,  0,  0,  0,  0),   { E }
      (192,192,192,193,193,195,195,193,225,248,  0,  0,  0,  0),   { R }
      (  0,  7,120,192,192,128,128,192,195,124,  0,  0,  0,  0),   {   }
      (224,224,224,224,224,224,224,240,112, 29,  0,  0,  0,  0),   { I }
      ( 56, 56, 56, 56, 56, 56, 56, 56,124,255,  0,  0,  0,  0),   { N }
      ( 31, 31, 31,  0,  0, 64, 96, 96,112, 71,  0,  0,  0,  0),   {   }
      (  0,224,248,252, 28, 12,  4, 12, 24,224,  0,  0,  0,  0),   { T }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),   { H }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),   { E }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),   {   }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),   { A }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),   { S }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),   { C }
      (  0,  0,252, 60, 30, 30, 30, 23, 23, 23, 19, 19, 19, 17),   { I }
      (  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,130,130,130,196),   { I }
      (  0,  0,126,120,240,240,240,112,112,112,112,112,112,112),   {   }
      (  0,  0, 28, 28, 28,  0,  0,  0,  0,252, 60, 28, 28, 28),   { C }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  6, 12, 28, 24),   { H }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,240, 12,  2,  7,  7),   { A }
      (  0,  0, 63, 15,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7),   { R }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0, 62, 65,129,128,  0),   { A }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,128,192,192,224),   { C }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0, 63, 64,224,224,224),   { T }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,192, 96,112,112),   { E }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  7, 24, 48,112, 96),   { R }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,192,112, 24, 28, 28),   {   }
      (  0,  0,252, 60, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28),   { S }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),   { E }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),   { T }
      (  0,  0, 63, 56, 48, 48, 32, 32, 32,  0,  0,  0,  0,  0),   {   }
      (  0,  0,255,112,112,112,112,112,112,112,112,112,112,112),   { O }
      (  0,  0,225,225, 97, 32, 32, 32, 32, 15,  3,  1,  1,  1),   { F }
      (  0,  0,192,192,192,  0,  0,  0,  0,192,193,195,195,195),   {   }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,252,  3,  0,  0,  0),   { T }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0, 64, 65,195, 71, 70),   { H }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,124,131,  0,  1,  1),   { E }
      (  0,  0, 15,  3,  1,  1,  1,  1,  1,  1,  1,129,193,193),   {   }
      (  0,  0,192,192,192,192,192,192,192,207,208,224,224,192),   { I }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,128, 96,112, 48, 56),   { B }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  3, 12, 24, 56, 48),   { M }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,224, 56, 12, 14, 14),   { - }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,126, 30, 14, 15, 15),   { P }
      (  0,  0,  0,  0,  0,  0,  0,  0,  0, 60, 78,142, 14,  0),   { C }
      ( 17, 17, 16, 16, 16, 16, 16, 16, 48,254,  0,  0,  0,  0),
      (196,196,232,232,232,112,112, 80, 32, 35,  0,  0,  0,  0),
      (112,112,112,112,112,112,112,112,248,254,  0,  0,  0,  0),
      ( 28, 28, 28, 28, 28, 28, 28, 28, 62,255,  0,  0,  0,  0),
      ( 56, 56, 56, 56, 56, 24, 28, 12,  6,129,  0,  0,  0,  0),
      (  7,  0,  0,  0,  0,  0,  1,  2, 12,240,  0,  0,  0,  0),
      (  7,  7,  7,  7,  7,  7,  7,  7, 15, 63,  0,  0,  0,  0),
      (  0,  0,  0,  0,  0,  0,  0,  0,129,231,  0,  0,  0,  0),
      (224,224,224,224,224,225,225,224,240,252,  0,  0,  0,  0),
      (  0,  3, 60,224,224,192,192,224,225, 62,  0,  0,  0,  0),
      (112,240,112,112,112,112,112,120,184, 14,  0,  0,  0,  0),
      (224,255,224,224,224, 96,112, 48, 24,  7,  0,  0,  0,  0),
      ( 28,252,  0,  0,  0,  0,  4,  8, 48,192,  0,  0,  0,  0),
      ( 28, 28, 28, 28, 28, 28, 28, 28, 62,255,  0,  0,  0,  0),
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,128,  0,  0,  0,  0),
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0,  0,  0),
      (112,112,112,112,112,112,112,112,248,254,  0,  0,  0,  0),
      (  1,  1,  1,  1,  1,  1,  1,  1,  3, 15,  0,  0,  0,  0),
      (193,193,192,192,192,194,195,195,227,250,  0,  0,  0,  0),
      (240,254,255, 15,  1,  0,  0,  0,129,126,  0,  0,  0,  0),
      ( 14, 14,142,206,206,198, 71,195,129,  0,  0,  0,  0,  0),
      (  1,  0,  0,  0,  0,  0,  0,  0,131,124,  0,  0,  0,  0),
      (193,  1,  1,  1,  1,  1, 65,129,  3, 15,  0,  0,  0,  0),
      (192,192,192,192,192,192,192,192,224,249,  0,  0,  0,  0),
      ( 56, 56, 56, 56, 56, 56, 56, 56,124,255,  0,  0,  0,  0),
      (112,127,112,112,112, 48, 56, 24, 12,  3,  0,  0,  0,  0),
      ( 14,254,  0,  0,  0,  0,  2,  4, 24,224,  0,  0,  0,  0),
      ( 14, 14, 14, 14, 14, 14, 14, 14, 31,127,  0,  0,  0,  0),
      (  0,  0,  0,  0,  0,  0,  0,  0,  0,192,  0,  0,  0,  0));

var   VLine{VLine},        { stores the current cursor position }
      VColumn{VColumn},
      NumLine{NumLine} : byte;              { number of screen lines }
      Mono    : boolean;                 { TRUE, if monochrome monitor }

{**********************************************************************}
{* CEmul: Switches the cursor emulation of the EGA card on or off.    *}
{* Input   : - DOIT = TRUE : Cursor emulation on.                     *}
{*                    FALSE: Cursor emulation off.                    *}
{* Output  : the current cursor column                                *}
{**********************************************************************}

procedure CEmul( DoIt : boolean );

var VioInfoByte : byte absolute $0040:$0087;          { BIOS info byte }

begin
  if DoIt then                                    { turn emulation on? }
    VioInfoByte := VioInfoByte or 1                   { yes, set bit 0 }
  else                                                            { NO }
    VioInfoByte := VioInfoByte and 254                { mask out bit 0 }
end;

{**********************************************************************}
{* GetCS: Returns the current output column.                          *}
{* Input   : none                                                     *}
{* Output  : the current cursor column                                *}
{**********************************************************************}

function GetCS : byte;

begin
  GetCS := VColumn;                  { get column from global variable }
end;

{**********************************************************************}
{* GetCZ: Return the current output line.                             *}
{* Input   : none                                                     *}
{* Output  : the current output line                                  *}
{**********************************************************************}

function GetCZ : byte;

begin
  GetCZ := VLine;                     { get line from global variable }
end;

{**********************************************************************}
{* CharDef: Defines the bit pattern of an individual character.       *}
{* Input   : - ASCII   = ASCII code of the first char to be defined   *}
{*           - TABLE   = number of the character table ( 0 bis 3 )    *}
{*           - MATRIX  = number of lines in the character matrix      *}
{*           - NUMBER  = number of characters to be defined           *}
{*           - BUFPTR  = pointer to the buffer with the character     *}
{* Output  : none                                                     *}
{**********************************************************************}

procedure CharDef( Ascii, Table, Matrix, Number : byte;
                   BufPtr : BytePtr );

var Regs : Registers;         { processor registers for interrupt call }

begin
  Regs.ax := $1100;         { ftn. no.: character generator, subftn. 0 }
  Regs.bh := Matrix;                       { line height of the matrix }
  Regs.bl := Table;                    { number of the character table }
  Regs.cx := Number;           { number of the character to be defined }
  Regs.dx := Ascii;                    { first character to be defined }
  Regs.bp := Ofs( BufPtr^ );            { offset address of the buffer }
  Regs.es := Seg( BufPtr^ );            {segment address of the buffer }
  intr(VIDEO_INT, Regs);                   { call BIOS video interrupt }
end;

{**********************************************************************}
{* GetMonTyp: Determines the type of monitor attached.                *}
{* Input   : none                                                     *}
{* Output  : the monitor type: MOMO  = monochrome monitor             *}
{                              COLOR = color monitor                  *}
{*                             EGA   = EGA or Multisync monitor       *}
{**********************************************************************}

function GetMonTyp : byte;

var Regs : Registers;         { processor registers for interrupt call }

begin
  Regs.ah := $12;                        { ftn. no.: get configuration }
  Regs.bl := $10;                                 { subfunction number }
  intr(VIDEO_INT, Regs);                   { call BIOS video interrupt }
  case Regs.cl of                        { CL contains the monitor type}
    $0B : GetMonTyp := MOMO;                      { monochrome monitor }
    $08 : GetMonTyp := COLOR;                          { color monitor }
    $09 : GetMonTyp := EGA;                              { EGA monitor }
  end;
end;

{**********************************************************************}
{* SetCur : Sets the blinking cursor and the internal output position *}
{* Input   : - COLUMN = output column  ( 0 .. 79 )                    *}
{*           - LINE   = output line    ( 1 .. n )                     *}
{* Output  : none                                                     *}
{**********************************************************************}

procedure SetCur( Column, Line : byte );

var Regs : Registers;         { processor registers for interrupt call }

begin
  Regs.ah := $2;                       { ftn. no.: set cursor position }
  Regs.bh := 0;                                        { screen page 0 }
  Regs.dh := Line;                                   { set coordinate }
  Regs.dl := Column;
  intr(VIDEO_INT, Regs);                   { call BIOS video interrupt }
  VLine := Line;             { save coordinates in internal variables }
  VColumn := Column;
end;

{**********************************************************************}
{* SetCol : Defines the contents of one of the 16 color registers in  *}
{*          the EGA card.                                             *}
{* Input   : - REGNR = number of the color register                   *}
{*           - COLOR = color value (0 to 63)                          *}
{* Output  : none                                                     *}
{**********************************************************************}

procedure SetCol(regnr, color : byte);

var Regs : Registers;         { processor registers for interrupt call }

begin
  Regs.ah := $10;                    { ftn. no.: set colors/attributes }
  Regs.al := 0;                                        { subfunction 0 }
  Regs.bl := regnr;                       { set number of the register }
  Regs.bh := color and 63;   { set color value (mask out bits 6 and 7) }
  intr(VIDEO_INT, Regs);                   { call BIOS video interrupt }
end;

{**********************************************************************}
{* SetBorder : Defines the border color.                              *}
{* Input   : - COLOR = color value (0 to 63)                          *}
{* Output  : none                                                     *}
{**********************************************************************}

procedure SetBorder(color : byte);

var Regs : Registers;         { processor registers for interrupt call }

begin
  Regs.ah := $10;                    { ftn. no.: set colors attributes }
  Regs.al := 1;                                        { subfunction 0 }
  Regs.bh := color and 63;   { set color value (mask out bits 6 and 7) }
  intr(VIDEO_INT, Regs);                   { call BIOS video interrupt }
end;

{**********************************************************************}
{* SetLines : Sets the number of lines.                               *}
{* Input    : Sub-function of function 11(h):                         *}
{*            $11 : 8x4 character set                                 *}
{*            $12 : 8x8 character set                                 *}
{*            $14 : 8x16 character set                                *}
{* Output   : none                                                    *}
{**********************************************************************}

procedure SetLines( Lines : byte);

var Regs : Registers;      { processor registers for interrupt call }

begin
  Regs.ah := $11;                      { ftn. no.: character generator }
  Regs.al :=  Lines;                        { sub-function of fnc. 11h }
  Regs.bl := 0;                                { use character table 0 }
  intr(VIDEO_INT, Regs);                   { call BIOS video interrupt }
end;

{**********************************************************************}
{* IsEga: Determines if an EGA card is installed and handles the      *}
{*        initialization of the global variables.                     *}
{* Input   : none                                                     *}
{* Output  : TRUE, if an EGA card is installed, else FALSE.           *}
{**********************************************************************}

function IsEga : boolean;

var Regs : Registers;         { processor registers for interrupt call }

begin
  Regs.ah := $12;                  { ftn. no.: get video configuration }
  Regs.bl := $10;                                 { subfunction number }
  intr(VIDEO_INT, Regs);                   { call BIOS video interrupt }
  if Regs.bl <> $10  then                  { is it an EGA or VGA card? }
    begin                                                        { yes }
      {*- create pointer to VRAM depending on the monitor connected  -*}
      Mono := Regs.bh = 1;          { connected to monochrome monitor? }
      IsEga := TRUE;                      { an EGA card was discovered }
    end
  else
    IsEga := FALSE;                           { no EGA card discovered }
end;

{**********************************************************************}
{* IsVga: Determines whether a VGA card is installed, and initializes *}
{*        the global variables.                                       *}
{* Input   : none                                                     *}
{* Output  : TRUE if a VGA card is installed, otherwise FALSE.        *}
{* Info    : Use this function BEFORE calling the ISEGA in your own   *}
{*           application, since the TRUE for some EGAs also applies   *}
{*           to this routine as well.                                 *}
{**********************************************************************}

function IsVga : boolean;

var Regs : Registers;      { processor register for the interrupt call }

begin
  Regs.ah := $1A;               { function no.: Determine video system }
  Regs.al := $00;
  intr(VIDEO_INT, Regs);                   { Call BIOS video interrupt }
  if ( Regs.al = $1A ) and (( Regs.bl = 7 ) or ( Regs.bl = 8 )) then
    begin                              { VGA card installed and active }
      Mono  := FALSE;
      IsVga := TRUE;                  { definitely a VGA card on board }
    end
  else
    IsVga := FALSE;                            { no VGA card connected }
end;

{**********************************************************************}
{* PrintAt: Outputs a string at the give screen position with a       *}
{*          certain attribute.                                        *}
{* Input  :  - COLUMN = output column  ( 0 .. 79 )                    *}
{*           - LINE   = output line   ( 0 .. NUMLINE-1 )              *}
{*           - COLOR  = attribute for the characters to be printed    *}
{*           - OUSTR  = the string to be printed                      *}
{* Output : none                                                      *}
{**********************************************************************}

procedure PrintAt( Column, Line, Color :
byte; OutStr : string8);

var ColorRAM : VRam absolute $B800:0000;     { describes physical VRAM }
    MonoRAM  : VRam absolute $B000:0000;     { describes physical VRAM }
    Index    : word;                       { index into the VRAM array }
    Stren,                        { length of the string to be printed }
    i        : byte;                   { running pointer to the string }

begin
  Stren := length( OutStr );                { get length of the string }
  Index := Line * 80 + Column;                { set index in the array }
     if Mono then
        begin                                                    { yes }
          for i:=1 to Stren do                { run through the string }
            begin
              MonoRAM[ Index ].Character := OutStr[i]; { set character }
              MonoRAM[ Index ].Attribute := Color;         { set color }
              inc( Index );                      { increment the index }
            end;
        end
      else                                { output to the color screen }
        begin
          for i:=1 to Stren do                { run through the string }
            begin
              ColorRAM[ Index ].Character := OutStr[i];{ set character }
              ColorRAM[ Index ].Attribute := Color;        { set color }
              inc( Index );                      { increment the index }
            end;
        end;
  {*-- calculate new cursor position ---------------------------------*}
  SetCur((VColumn + VLine * 80 + Stren) mod 80,
         (VColumn + VLine * 80 + Stren) div 80);
end;

{**********************************************************************}
{* Blinking : Defines the meaning of bit 7 in the attribute of a      *}
{*            character in the text modes.                            *}
{* Input   : - DoBlink = TRUE : blinking                              *}
{*                       FALSE: intense background color              *}
{* Output  : none                                                     *}
{**********************************************************************}

procedure Blinking( DoBlink : boolean );

var Regs : Registers;      { processor registers for interrupt call }

begin
  Regs.ah := $10;                    { ftn. no.: set colors/attributes }
  Regs.al := $3;                                  { subfunction number }
  if DoBlink then                                          { blinking? }
    Regs.bl := 1                              { yes, BL = 1 : blinking }
  else                                                            { no }
    Regs.bl := 0;             { yes, BL = 0 : intense background color }
  intr(VIDEO_INT, Regs);                   { call BIOS video interrupt }
end;


{**********************************************************************}
{* Cls: Clears the screen, causing the video mode to be reset.        *}
{*      The palette registers will also be filled with the default    *}
{*      values and the character set will be reset.                   *}
{* Input   : none                                                     *}
{* Output  : none                                                     *}
{**********************************************************************}

procedure Cls;

var Regs : Registers;         { processor registers for interrupt call }

begin
  Regs.ah := $0;                            { ftn. no.: set video mode }
  if Mono then                       { connected to monochrome monitor }
    Regs.al := 7                             { yes, 80x25 text display }
  else                                             { no, color monitor }
    Regs.al := 3;                  { yes, 80x25 character text display }
  intr(VIDEO_INT, Regs);                   { call BIOS video interrupt }
end;

{**********************************************************************}
{* EgaVga : Demonstrates how to use the functions of the EGA/VGA BIOS.*}
{* Input   : TRUE if VGA card installed, otherwise FALSE              *}
{* Output  : none                                                     *}
{**********************************************************************}

procedure EgaVga (VGA : boolean);

var i, j, k : word;                                     { loop counter }
    OutStr  : string8;                            { logo output string }
    Regs    : Registers;   { processor register for the interrupt call }

begin
  {*-- Add EGA/VGA hardcopy routine *}
  Regs.ah := $12;                          { alternate select function }
  Regs.bl := $20;                         { sub-function: install rtne }
  intr(VIDEO_INT,Regs);                               { call interrupt }
  {*-- prepare screen layout -----------------------------------------*}
  SetCur(0,0);
  Cls;                                              { clear the screen }
  Blinking( FALSE );            { light background instead of blinking }

  if ( VGA ) then     { Check compatibility in case characters must be }
    begin             { redefined, and the characters must be changed  }
      Regs.ah := $12; { into 350-line mode (changed back into EGA      }
      Regs.bl := $30; { mode).                                         }
      Regs.al := 1;
      intr(VIDEO_INT, Regs);               { call BIOS video interrupt }

      SetLines( $11 );                   { activate 8x14 character set }
    end;

  CharDef(128, 0, 14, 120, BytePtr(@font));         { define character }

  for i:=1 to 250 do                  { run through the loop 500 times }
    begin                          { write color bars to the video RAM }
      PrintAt(GetCs, GetCZ, ((i mod 14) + 1) shl 4, '     ');
      if i <> 250 then                               { last color bar? }
        PrintAt(GetCs, GetCZ, 0, '   ');                          { no }
    end;
  for i:=10 to 15 do                              { make room for logo }
    PrinTat(22, i, 0, '                                  ');
  k := 128;                                  { first character in logo }
  for i:=0 to 3 do                      { the logo consists of 4 lines }
    begin
      OutStr := '';                                 { empty the string }
      for j:=1 to 30 do          { each line consists of 30 characters }
        begin
          OutStr := OutStr + chr( k ); { append the char to the string }
          inc( k );                                      { increment K }
        end;
      PrintAt(24, i+11, 15, OutStr);              { output the string  }
    end;
  PrintAt(1, 1, 15, ' The most important characters are   ');
  PrintAt(1, 2, 15, ' still present in spite of the logo! ');
  Printat(1, 3, 15, '                                 ');
  Printat(1, 4, 15, ' !"#$%&''()*+-./0123456789:;<=>?@ ');
  Printat(1, 5, 15, ' ABCDEFGHIJKLMNOPQRSTUVXXYZ[\]^_ ');
  Printat(1, 6, 15, ' `abcdefghijklmnopqrstuvxyz{|}~  ');
  Printat(33, 21, 15, '                                           ');
  Printat(33, 22, 15, '     press any key to end the program.     ');
  Printat(33, 23, 15, '                                           ');
  SetCur(34, 22);
  {*-- change the colors in the color bars --------------------------*}
  i := 0;                       { start value for the color registers }
  while ( not KeyPressed ) do           { repeat until key is pressed }
    begin
      inc( i );    { increment the color value for the first register }
        for j:=1 to 14 do             { run through registers 1 to 14 }
        SetCol(j, i+j and 63);    { write color value in the register }
      end;

  if ( VGA ) then           { Switch VGA card back into 400-line mode }
    begin
      Regs.ah := $12;
      Regs.bl := $30;
      Regs.al := 2;
      intr(VIDEO_INT, Regs);              { call BIOS video interrupt }

      SetLines( $14 );                  { activate 8x16 character set }
    end;

  Cls;                                                 { clear screen }
end;

{**********************************************************************}
{**                           MAIN PROGRAM                           **}
{**********************************************************************}

begin
  if IsVga then                                  { VGA card installed? }
    EgaVga( true )                                     { YES, run demo }
  else
    begin
      if IsEga then                              { EGA card installed? }
        begin                                                    { YES }
          if ( GetMonTyp = EGA ) then          { EGA monitor attached? }
            EgaVga( false )                            { YES, run demo }
          else                                     { NO, wrong monitor }
            begin
              writeln('This program only works with an EGA ');
              writeln('card or VGA card, and a monitor     ');
              writeln('supported by one of these cards.    ');
            end;
        end
      else
        writeln( 'No EGA or VGA card installed...'+
                 ' Program aborted.' );
    end;
end.
