/*********************************************************************/
/*                                 R T C                             */
/*-------------------------------------------------------------------*/
/*    Task          : provides two Functions for reading and writing */
/*                    Data in the Real Time clock                    */
/*-------------------------------------------------------------------*/
/*    Author        : MICHAEL TISCHER                                */
/*    developed on  : 8.15.87                                        */
/*    last Update   : 9.21.87                                        */
/*-------------------------------------------------------------------*/
/*    (MICROSOFT C)                                                  */
/*    Creation      : MSC RTCC;                                      */
/*                    LINK RTCC;                                     */
/*    Call          : RTCC                                           */
/*-------------------------------------------------------------------*/
/*    (BORLAND TURBO C)                                              */
/*    Creation      : Through the RUN command in the command line    */
/*********************************************************************/

#include <dos.h>                             /* Include header-files */
#include <conio.h>

#define byte unsigned char

#define RTCAdrPort  0x70              /* address-register of the RTC */
#define RTCDtaPort  0x71                 /* data-register of the RTC */

#define SECONDS      0  /* addresses of some memory locations of RTC */
#define MINUTE       2
#define HOUR         4
#define DAYOFWEEK    6
#define DAY          7
#define MONTH        8
#define YEAR         9
#define STATUSA     10
#define STATUSB     11
#define STATUSC     12
#define STATUSD     13
#define DIAGNOSE    14
#define YEARHUNDRED 50

/*********************************************************************/
/* RTCREAD: reads the content of a memory location of the RTC        */
/* Input  : the address of the memory location in the RTC            */
/* Output : the Content of this memory location                      */
/*********************************************************************/

byte RTCRead(Address)
byte Address;                      /* the memory location of the RTC */

{
 outp(RTCAdrPort, Address);           /* transmit address to the RTC */
 return(inp(RTCDtaPort));     /* read content and transmit to caller */
}

/*********************************************************************/
/* RTCDT  : reads date or time from one of the memory locations      */
/*          and converts the result into a Binary value              */
/*          if the clock works in BCD-Format                         */
/* Input  : the address of the memory location in the RTC            */
/* Output : the content of this memory location as Binary Value      */
/* Info    :if the address is outside the permitted area             */
/*          (0 to 63) the Value -1 is returned                       */
/*********************************************************************/

byte RTCDt(Address)
byte Address;                      /* the memory location in the RTC */

{
 if (RTCRead(STATUSB) & 2)                   /* BCD- or binary mode? */
  return((RTCRead(Address) >> 4) * 10 + (RTCRead(Address) & 15));
 else return(RTCRead(Address));                    /* is binary mode */
}

/*********************************************************************/
/* RTCWRITE: write a value into one of the memory locations of RTC   */
/* Input   : see below                                               */
/* Output  : none                                                    */
/* Info    : the address must be between 0 to 63                     */
/*********************************************************************/

void RTCWrite(Address, Content)
byte Address;                      /* address of the memory location */

{
 outp(RTCAdrPort, Address);           /* transmit address to the RTC */
 outp(RTCDtaPort, Content);                       /* write new value */
}

/*********************************************************************/
/**                             MAIN PROGRAM                        **/
/*********************************************************************/

void main()

{
 static char *Weekdays[] =                  /* Names of the weekdays */
                           {
"Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"
                           };

 printf("\nRTC (c) 1987 by Michael Tischer\n\n");
 printf("Information from the real time clock\n");
 printf("=====================================================\n\n");
 if (!(RTCRead(DIAGNOSE) & 128))             /* is the Battery o.k.? */
  {                                           /* the Battery is o.k. */
   printf("- The clock is operated in %d hour mode \n",
          (RTCRead(STATUSB) & 2)*6+12);
   printf("- the time: %2d:%2d:%2d\n",
          RTCDt(HOUR), RTCDt(MINUTE), RTCDt(SECONDS));
   printf("- the date: ");
   printf("%s, der %d.%d.%d%d\n", Weekdays[RTCDt(DAYOFWEEK)-1],
          RTCDt(DAY), RTCDt(MONTH), RTCDt(YEARHUNDRED), RTCDt(YEAR));
  }
 else printf("       WARNING! The battery of the clock is low!\n");
}

