/*********************************************************************/
/*                               M O V E C                           */
/*-------------------------------------------------------------------*/
/*    Task         : integrates an Assembler-Routine in C, which can */
/*                   move memory blocks beyond the 1 MB boundary     */
/*-------------------------------------------------------------------*/
/*    Author         : MICHAEL TISCHER                               */
/*    developed on   : 8.13.87                                       */
/*    last Update    : 9.21.87                                       */
/*-------------------------------------------------------------------*/
/*    (MICROSOFT C)                                                  */
/*    Creation       : MSC MOVEC;                                    */
/*                     LINK MOVEC MOVECA PEPO;                       */
/*    Call           : MOVEC                                         */
/*-------------------------------------------------------------------*/
/*    (BORLAND TURBO C)                                              */
/*    Creation       : with Project-File with the following content: */
/*                     movec                                         */
/*                     moveca.obj                                    */
/*********************************************************************/

#include <dos.h>                          /* include Header-Files */
#include <io.h>
#include <conio.h>

extern void AdMove();                /* ADMOVE must be linked  */
extern int PeekB();                  /* PEEKB must be linked  */

/*********************************************************************/
/* GETPAGE; returns the Address of the current display page          */
/* Input : none                                                      */
/* Output : see below                                                */
/*********************************************************************/

unsigned int GetPAge()

{
 union REGS Register;       /* Register-Variable for Interrupt call */

 Register.h.ah = 15;      /* Function number to get Video parameter */
 int86(0x10, &Register, &Register);       /* Call Interrupt 10(h) */
 return((Register.h.al == 7) ? 0xB000 : 0xB800);
}

/*******************************************************************/
/* CLS: Clear Screen                                               */
/* Input : none                                                    */
/* Output : none                                                   */
/*******************************************************************/

void Cls()

{
 union REGS Register;       /* Register-Variable for Interrupt call */

 Register.h.ah = 6;              /* Function number for Scroll-UP */
 Register.h.al = 0;                            /* 0 is for clear  */
 Register.h.bh = 7;       /* white characters on black background */
 Register.x.cx = 0;                 /* upper left display corner  */
 Register.h.dh = 24;                  /* Coordinates of the lower */
 Register.h.dl = 79;                     /* right display corner  */
 int86(0x10, &Register, &Register);  /* Call BIOS-Video-Interrupt */
}

/*********************************************************************/
/**                           MAIN PROGRAM                          **/
/*********************************************************************/

void main()

{
 printf("\nMOVE (c) 1987 by Michael Tischer\n\n");
 printf("This Program uses the Function 87(h) of Interrupt 15(h)");
 printf(" to move memory blocks\nbetween the \"normal\" RAM and the ");
 printf("RAM beyond the 1 Mega-Byte storage limit.\n");
 if (PeekB(0xF000, 0xFFFE) != 0xFC)                   /* test if AT */
  {
 printf("Since this PC is not an AT, but a ");
 printf("PC or XT\nand this PC can not have RAM ");
 printf("beyond the 1 MB storage limit, ");
 printf("this program can not be executed! Sorry...\n\n");
  }
 else
  {
   printf("After starting the program by pressing a key ");
   printf("the current display\n content is ");
   printf("copied directly beyond the 1 MB-limit\n ");
   printf("and then the display is cleared. If another key is ");
   printf("\npressed ,the old display is again  ");
   printf("restored.\n\nPlease press a key to ");
   printf("start the Program ...");
   getch();                                 /* wait for a key  */

   /*-- Copy current Video Rrm beyond 1 MB -----------------------*/
   AdMove(GetPage(), 0x0000, 0x0000, 0x0000, 0x2000, 1);

   Cls();                                      /* Clear Screen */
   printf("\nPlease press a key ...");
   getch();                                    /* get a key */

   /*-- Restore Video-RAM ------------------------------------*/
   AdMove(0x0000, 0x0000, GetPage(), 0x0000, 0x2000, 2);
   printf("\n\nThat's It!\n");
  }
}
