;*********************************************************************;
;*                             C O N D R V                           *;
;*-------------------------------------------------------------------*;
;*    Task        : This program represents a normal Console         *;
;*                  Driver (Keyboard and Display Monitor). It should *;
;*                  serve as a framework for a driver in the form of *;
;*                  an ANSI.SYS driver.                              *;
;*-------------------------------------------------------------------*;
;*    Author         : MICHAEL TISCHER                               *;
;*    developed on   : 08/04/87                                      *;
;*    last Update    : 05/14/89                                      *;
;*-------------------------------------------------------------------*;
;*    assembly       : MASM CONDRV;                                  *;
;*                     LINK CONDRV;                                  *;
;*                     EXE2BIN CONDRV CONDRV.SYS                     *;
;*-------------------------------------------------------------------*;
;*    Call         : Copy into Root Directory, copy the command      *;
;*                   DEVICE=CONDRV.SYS into the file CONFIG.SYS      *;
;*                   and then boot the System.                       *;
;*********************************************************************;

code     segment

         assume cs:code,ds:code,es:code,ss:code

         org 0                   ;Program has no PSP therefore start 
                                 ;at Offset address 0

;== Constants =========================================================

cmd_fld  equ 2                   ;Offset command field in data block
status   equ 3                   ;Offset status field in data block
end_adr  equ 14                  ;Offset driver end-adr. in data block
num_db   equ 18                  ;Offset number in data block
b_adr    equ 14                  ;Offset buffer address in data block

KEY_SZ   equ 20                  ;Size of key board buffer
num_cmd  equ 16                  ;Subfunctions 0-16 are supported 

;== Data ==============================================================

;-- Header of Device Driver -------------------------------------------

         dw -1,-1                ;Connection to next driver
         dw 1010100000000011b    ;Driver attribute
         dw offset strat         ;Pointer to strategy routine
         dw offset intr          ;Pointer to interrupt routine
         db "CONDRV  "           ;new Console driver

;-- Jump Table for functions -------------------------

fct_tab  dw offset init          ;Function  0: Initialization
         dw offset dummy         ;Function  1: Media Check
         dw offset dummy         ;Function  2: Create BPB
         dw offset no_sup        ;Function  3: I/O control read 
         dw offset read          ;Function  4: Read  
         dw offset read_b        ;Function  5: Non-dest. Read
         dw offset dummy         ;Function  6: Input-Status
         dw offset del_in_b      ;Function  7: Erase Input-Buffer
         dw offset write         ;Function  8: Write 
         dw offset write         ;Function  9: Write & Verify 
         dw offset dummy         ;Function 10: Output-Status
         dw offset dummy         ;Function 11: Erase Output-Buffer 
         dw offset no_sup        ;Function 12: I/O control write 
         dw offset dummy         ;Function 13: Open (starting at 3.0)
         dw offset dummy         ;Function 14: Close 
         dw offset dummy         ;Function 15: changeable Medium
         dw offset write         ;Function 16: Output until Busy 

db_ptr   dw (?),(?)              ;Address of data block passed 

key_a    dw 0                    ;Pointer to next character in KEY_SZ
key_e    dw 0                    ;Pointer to last character in KEY_SZ
key_bu   db KEY_SZ dup (?)       ;internal Keyboard Buffer 

;== Routines and functions of driver ===============================

strat    proc far                ;Strategy routine

         mov  cs:db_ptr,bx       ;Store address of data block in the 
         mov  cs:db_ptr+2,es     ;Variable DB_PTR 

         ret                     ;back to caller 

strat    endp

;----------------------------------------------------------------------

intr     proc far                ;Interrupt routine

         push ax                 ;Store registers on the stack 
         push bx
         push cx
         push dx
         push di
         push si
         push bp
         push ds
         push es
         pushf                   ;store also the flag register 

         push cs                 ;Set data segment register 
         pop  ds                 ;Code is identical here with data 

         les  di,dword ptr db_ptr;Address of data block to ES:DI
         mov  bl,es:[di+cmd_fld] ;Get command-code 
         cmp  bl,num_cmd         ;is command-code permitted?
         jle  bc_ok              ;YES --> bc_ok

         mov  ax,8003h           ;Code for "unknown Command"
         jmp  short intr_end     ;back to caller 

         ;-- Command-Code was o.k. --> Execute command ----------------

bc_ok:   shl  bl,1               ;Calculate pointer in jump table
         xor  bh,bh              ;erase BH 
         call [fct_tab+bx]       ;Call function
         les  di,dword ptr db_ptr;Address of the data block to ES:DI

         ;-- Execution of the function completed  --------------------

intr_end label near
         or   ax,0100h           ;Set finished-bit 
         mov  es:[di+status],ax  ;store everything in the status field 

         popf                    ;Restore flag register 
         pop  es                 ;Restore other registers 
         pop  ds
         pop  bp
         pop  si
         pop  di
         pop  dx
         pop  cx
         pop  bx
         pop  ax

         ret                     ;back to caller 

intr     endp

;----------------------------------------------------------------------

dummy    proc near               ;This routine does nothing 

         xor  ax,ax              ;Erase busy-bit 
         ret                     ;back to caller 

dummy    endp

;----------------------------------------------------------------------

no_sup   proc near              ;This routine called for all functions
                                 ;which should really not be called 
         mov  ax,8003h           ;Error: Command not recognized
         ret                     ;back to caller 

no_sup   endp

;----------------------------------------------------------------------

store_c  proc near               ;stores a character in the internal 
                                 ;keyboard buffer 
                                 ;Input: AL = character
                                 ;       BX = Position of the character 

         mov  [bx+key_bu],al     ;store character in internal buffer 
         inc  bl                 ;increment pointer to End 
         cmp  bl,KEY_SZ          ;End of buffer reached ?
         jne  store_e            ;NO --> STORE_E

         xor  bl,bl              ;new end is the beginning of buffer 

store_e: ret                     ;back to caller 

store_c  endp

;----------------------------------------------------------------------

read    proc near                ;read a certain number of characters
                                 ;from the keyboard to a buffer 

         mov  cx,es:[di+num_db]  ;read number of characters 
         jcxz read_e             ;test if equal to 0
         les  di,es:[di+b_adr]   ;Address of character buffer to ES:DI
         cld                     ;on STOSB count up 
         mov  si,key_a           ;Pointer to next character in KEY_SZ
         mov  bx,key_e           ;Pointer to last character in KEY_SZ

read_1: cmp  si,bx               ;other characters in keyboard buffer?
         jne  read_3             ;YES --> READ_3

read_2: xor  ah,ah               ;Function number for reading is 0
         int  16h                ;Call BIOS Keyboard-interrupt
         call store_c            ;Store characters in internal buffer 
         cmp  al,0               ;test if extended code
         jne  read_3             ;no --> READ_3

         mov  al,ah              ;Extended Code is in AH
         call store_c            ;store 
read_3: mov  al,[si+key_bu]      ;read character from keyboard buffer 
         stosb                   ;transmit to buffer of calling funct.
         inc  si                 ;Increment pointer to next character 
         cmp  si,KEY_SZ          ;End of buffer reached?
         jne  read_4             ;NO --> READ_4

         xor  si,si              ;next character is the first character 
                                 ;in the keyboard buffer 

read_4: loop read_1              ;repeat until all characters read 
         mov  key_a,si           ;Store position of the next character
                                 ;in the key board buffer 
         mov  byte ptr key_e,bl  ;Store position of the last character
                                 ;in the key board buffer 

read_e: xor  ax,ax               ;everything o.k.
         ret                     ;back to caller 

read    endp

;----------------------------------------------------------------------

read_b  proc near                ;read the next character from the
                                 ;key board but leave in the buffer 

         mov  ah,1               ;Function number for BIOS-interrupt
         int  16h                ;call BIOS Keyboard-interrupt 
         je   read_p1            ;no character present --> READ_P1

         mov  es:[di+13],al      ;store character in data block 
         xor ax,ax               ;everything o.k.
         ret                     ;back to caller 

read_p1 label near

         mov  ax,0100h           ;Set busy-bit (no character)
         ret                     ;back to caller 

read_b  endp

;----------------------------------------------------------------------

del_in_b proc near               ;erase input buffer 

         mov  ah,1               ;Still characters in the buffer?
         int  16h                ;Call BIOS key board interrupt 
         je   del_e              ;no character in the buffer --> END

         xor  ah,ah              ;Remove character from buffer 
         int  16h                ;Call BIOS key board interrupt 
         jmp  short del_in_b     ;Test for additional characters 

del_e:   xor ax,ax               ;everything o.k.
         ret                     ;back to caller 

del_in_b endp

;----------------------------------------------------------------------

write proc near                  ;write a specified number of 
                                 ;characters on the display screen 

         mov  cx,es:[di+num_db]  ;Number of characters read 
         jcxz write_e            ;test if equal to 0
         lds  si,es:[di+b_adr]   ;Address of character-buffer to DS:SI
         cld                     ;on LODSB increment count 

         mov  ah,3               ;read current display page 
         int  16h                ;Call BIOS Video-interrupt 

         mov  ah,14              ;Function number for BIOS interrupt

write_1:  lodsb                  ;read character to be output to AL 
         int  10h                ;call BIOS Video-interrupt 
         loop write_1            ;repeat until all characters output

write_e:  xor ax,ax              ;everything o.k.
         ret                     ;back to caller 

write endp

;----------------------------------------------------------------------

init     proc near               ;Initialization routine

         mov  word ptr es:[di+end_adr],offset init  ;Set End-Address of
         mov  es:[di+end_adr+2],cs                  ;the driver 

         xor  ax,ax              ;everything o.k.
         ret                     ;back to caller 

init     endp

;======================================================================

code     ends
         end

